/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.console;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.TempFileProvider;
import org.web3j.console.Runner;
import org.web3j.utils.Strings;

public class RunnerTest
extends TempFileProvider {
    private Logger logger = LoggerFactory.getLogger(RunnerTest.class);
    private String bin = "contract/HumanStandardToken.bin";
    private String abi = "contract/HumanStandardToken.abi";
    private String wasmbin = "contract/ContractDistory.wasm";
    private String wasmabi = "contract/ContractDistory.abi.json";

    @Test
    public void generateJavaCode() {
        String binPath = RunnerTest.class.getClassLoader().getResource(this.bin).getPath();
        String abiPath = RunnerTest.class.getClassLoader().getResource(this.abi).getPath();
        String outputPath = this.tempDirPath;
        String packageName = "com.platon.sdk.contracts";
        String[] params = new String[]{"solidity", "generate", binPath, abiPath, "-o", outputPath, "-p", packageName};
        try {
            Runner.main((String[])params);
        }
        catch (Exception e) {
            this.logger.error("Failed to generate Java code: " + e.getMessage(), (Throwable)e);
        }
        String sourceFile = this.tempDirPath + File.separator + packageName.replace('.', File.separatorChar) + File.separator + Strings.capitaliseFirstLetter((String)"HumanStandardToken") + ".java";
        boolean condition = new File(sourceFile).exists();
        Assert.assertTrue((String)"Java wrapper source code generator for Solidity ABI format error.", (boolean)condition);
    }

    @Test
    public void generateWasmJavaCode() {
        String binPath = RunnerTest.class.getClassLoader().getResource(this.wasmbin).getPath();
        String abiPath = RunnerTest.class.getClassLoader().getResource(this.wasmabi).getPath();
        String outputPath = this.tempDirPath;
        String packageName = "com.platon.sdk.contracts";
        String[] params = new String[]{"wasm", "generate", binPath, abiPath, "-o", outputPath, "-p", packageName};
        try {
            Runner.main((String[])params);
        }
        catch (Exception e) {
            this.logger.error("Failed to generate Java code: " + e.getMessage(), (Throwable)e);
        }
        String sourceFile = this.tempDirPath + File.separator + packageName.replace('.', File.separatorChar) + File.separator + Strings.capitaliseFirstLetter((String)"ContractDistory") + ".java";
        boolean condition = new File(sourceFile).exists();
        Assert.assertTrue((String)"Java wrapper source code generator for Solidity ABI format error.", (boolean)condition);
    }
}

