/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.Arrays;
import org.web3j.abi.datatypes.Type;

public class BytesType
implements Type<byte[]> {
    public static final String TYPE_NAME = "bytes";
    private byte[] value;
    private String type;

    public BytesType(byte[] src, String type) {
        this.value = src;
        this.type = type;
    }

    public BytesType(byte[] src) {
        this.value = src;
        this.type = TYPE_NAME + src.length;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesType bytesType = (BytesType)o;
        if (!Arrays.equals(this.value, bytesType.value)) {
            return false;
        }
        return this.type.equals(bytesType.type);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.value);
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

