/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.ArrayList;
import java.util.List;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Type;

public class Event {
    private String name;
    private int functionType;
    private List<TypeReference<Type>> indexedParameters = new ArrayList<TypeReference<Type>>();
    private List<TypeReference<Type>> nonIndexedParameters = new ArrayList<TypeReference<Type>>();

    public Event(String name, List<TypeReference<?>> parameters) {
        this.name = name;
        this.nonIndexedParameters = this.convert(parameters);
    }

    public Event(int functionType, List<TypeReference<?>> parameters) {
        this.functionType = functionType;
        this.nonIndexedParameters = this.convert(parameters);
    }

    public Event(String name, List<TypeReference<?>> indexedParameters, List<TypeReference<?>> nonIndexedParameters) {
        this.name = name;
        this.indexedParameters = this.convert(indexedParameters);
        this.nonIndexedParameters = this.convert(nonIndexedParameters);
    }

    public Event(int functionType, List<TypeReference<?>> indexedParameters, List<TypeReference<?>> nonIndexedParameters) {
        this.functionType = functionType;
        this.indexedParameters = this.convert(indexedParameters);
        this.nonIndexedParameters = this.convert(nonIndexedParameters);
    }

    public String getName() {
        return this.name;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public List<TypeReference<Type>> getIndexedParameters() {
        return this.indexedParameters;
    }

    public List<TypeReference<Type>> getNonIndexedParameters() {
        return this.nonIndexedParameters;
    }

    private List<TypeReference<Type>> convert(List<TypeReference<?>> parameters) {
        ArrayList<TypeReference<Type>> typeReferenceList = new ArrayList<TypeReference<Type>>();
        for (TypeReference<?> typeReference : parameters) {
            if (typeReference.isIndexed()) continue;
            typeReferenceList.add(typeReference);
        }
        return typeReferenceList;
    }
}

