/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.platon;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.IntType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.platon.CustomStaticArray;
import org.web3j.platon.CustomType;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.Numeric;

public class PlatOnFunction {
    private static final BigInteger BASE_DEFAULT_GAS_PRICE = BigInteger.valueOf(500000000000L);
    private static final BigInteger BASE_DEFAULT_GAS_LIMIT = BigInteger.valueOf(21000L);
    private static final BigInteger BASE_NON_ZERO_GAS_LIMIT = BigInteger.valueOf(68L);
    private static final BigInteger BASE_ZERO_GAS_LIMIT = BigInteger.valueOf(4L);
    private int type;
    private List<Type> inputParameters;
    protected GasProvider gasProvider;

    public PlatOnFunction(int type) {
        this.type = type;
    }

    public PlatOnFunction(int type, GasProvider gasProvider) {
        this.type = type;
        this.gasProvider = gasProvider;
    }

    public PlatOnFunction(int type, List<Type> inputParameters) {
        this.type = type;
        this.inputParameters = inputParameters;
    }

    public PlatOnFunction(int type, List<Type> inputParameters, GasProvider gasProvider) {
        this.type = type;
        this.inputParameters = inputParameters;
        this.gasProvider = gasProvider;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public List<Type> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<Type> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public GasProvider getGasProvider() {
        if (this.gasProvider == null) {
            BigInteger gasLimit = BASE_DEFAULT_GAS_LIMIT.add(this.getContractGasLimit()).add(this.getFunctionGasLimit()).add(this.getInterfaceDynamicGasLimit()).add(this.getDataGasLimit());
            return new ContractGasProvider(this.getGasPrice(), gasLimit);
        }
        return this.gasProvider;
    }

    public BigInteger getFeeAmount(BigInteger gasPrice) {
        BigInteger gasLimit = BASE_DEFAULT_GAS_LIMIT.add(this.getContractGasLimit()).add(this.getFunctionGasLimit()).add(this.getInterfaceDynamicGasLimit()).add(this.getDataGasLimit());
        return gasLimit.multiply(gasPrice == null || gasPrice.compareTo(BigInteger.ZERO) != 1 ? this.getGasPrice() : gasPrice);
    }

    private BigInteger getGasPrice() {
        switch (this.type) {
            case 2000: {
                return BigInteger.valueOf(1500000L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2001: {
                return BigInteger.valueOf(0x200B20L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2002: {
                return BigInteger.valueOf(2000000L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2005: {
                return BigInteger.valueOf(3000000L).multiply(BigInteger.valueOf(1000000000L));
            }
        }
        return BASE_DEFAULT_GAS_PRICE;
    }

    private BigInteger getContractGasLimit() {
        switch (this.type) {
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: {
                return BigInteger.valueOf(6000L);
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return BigInteger.valueOf(9000L);
            }
            case 3000: {
                return BigInteger.valueOf(21000L);
            }
            case 4000: {
                return BigInteger.valueOf(18000L);
            }
        }
        return BigInteger.valueOf(0L);
    }

    private BigInteger getFunctionGasLimit() {
        switch (this.type) {
            case 2002: 
            case 2005: {
                return BigInteger.valueOf(500000L);
            }
            case 2001: {
                return BigInteger.valueOf(450000L);
            }
            case 2000: {
                return BigInteger.valueOf(320000L);
            }
            case 1000: {
                return BigInteger.valueOf(32000L);
            }
            case 1001: {
                return BigInteger.valueOf(12000L);
            }
            case 1002: 
            case 1003: {
                return BigInteger.valueOf(20000L);
            }
            case 1004: {
                return BigInteger.valueOf(16000L);
            }
            case 1005: 
            case 4000: {
                return BigInteger.valueOf(8000L);
            }
            case 2004: {
                return BigInteger.valueOf(3000L);
            }
            case 2003: {
                return BigInteger.valueOf(2000L);
            }
            case 3000: {
                return BigInteger.valueOf(42000L);
            }
        }
        return BigInteger.valueOf(0L);
    }

    private BigInteger getInterfaceDynamicGasLimit() {
        if (this.type == 4000 && this.inputParameters.size() > 1 && this.inputParameters.get(1) instanceof CustomStaticArray) {
            return BigInteger.valueOf(((CustomStaticArray)this.inputParameters.get(1)).getValue().size()).multiply(BASE_DEFAULT_GAS_LIMIT);
        }
        return BigInteger.ZERO;
    }

    private BigInteger getDataGasLimit() {
        byte[] bytes = Numeric.hexStringToByteArray((String)this.getEncodeData());
        int nonZeroSize = 0;
        int zeroSize = 0;
        for (byte b : bytes) {
            if (b != 0) {
                ++nonZeroSize;
                continue;
            }
            ++zeroSize;
        }
        return BigInteger.valueOf(nonZeroSize).multiply(BASE_NON_ZERO_GAS_LIMIT).add(BigInteger.valueOf(zeroSize).multiply(BASE_ZERO_GAS_LIMIT));
    }

    public String getEncodeData() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((long)this.type))));
        List<Type> parameters = this.inputParameters;
        if (parameters != null && parameters.size() > 0) {
            for (Type parameter : parameters) {
                if (parameter instanceof IntType) {
                    result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((BigInteger)((IntType)parameter).getValue()))));
                    continue;
                }
                if (parameter instanceof BytesType) {
                    result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((byte[])((BytesType)parameter).getValue()))));
                    continue;
                }
                if (parameter instanceof Utf8String) {
                    result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((String)((Utf8String)parameter).getValue()))));
                    continue;
                }
                if (parameter instanceof CustomStaticArray) {
                    result.add(((CustomStaticArray)parameter).getRlpEncodeData());
                    continue;
                }
                if (!(parameter instanceof CustomType)) continue;
                result.add(((CustomType)parameter).getRlpEncodeData());
            }
        }
        String data = Hex.toHexString((byte[])RlpEncoder.encode((RlpType)new RlpList(result)));
        return data;
    }
}

