/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.platon.contracts;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint64;
import org.web3j.crypto.Credentials;
import org.web3j.platon.BaseResponse;
import org.web3j.platon.PlatOnFunction;
import org.web3j.platon.StakingAmountType;
import org.web3j.platon.bean.Delegation;
import org.web3j.platon.bean.DelegationIdInfo;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.PlatOnContract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.JSONUtil;
import org.web3j.utils.Numeric;

public class DelegateContract
extends PlatOnContract {
    public static DelegateContract load(Web3j web3j) {
        return new DelegateContract("0x1000000000000000000000000000000000000002", web3j);
    }

    public static DelegateContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new DelegateContract("0x1000000000000000000000000000000000000002", chainId, web3j, credentials);
    }

    public static DelegateContract load(Web3j web3j, TransactionManager transactionManager) {
        return new DelegateContract("0x1000000000000000000000000000000000000002", web3j, transactionManager);
    }

    private DelegateContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private DelegateContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<BaseResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        PlatOnFunction function = this.createDelegateFunction(nodeId, stakingAmountType, amount, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = this.createDelegateFunction(nodeId, stakingAmountType, amount, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getDelegateGasProvider(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        PlatOnFunction function = this.createDelegateFunction(nodeId, stakingAmountType, amount, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        PlatOnFunction function = this.createDelegateFunction(nodeId, stakingAmountType, amount, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = this.createDelegateFunction(nodeId, stakingAmountType, amount, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getDelegateResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 1004);
    }

    private PlatOnFunction createDelegateFunction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(1004, Arrays.asList(new Uint16((long)stakingAmountType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        PlatOnFunction function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getUnDelegateGasProvider(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        PlatOnFunction function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        PlatOnFunction function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getUnDelegateResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 1005);
    }

    private PlatOnFunction createUnDelegateFunction(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(1005, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse<Delegation>> getDelegateInfo(String nodeId, String delAddr, BigInteger stakingBlockNum) {
        final PlatOnFunction function = new PlatOnFunction(1104, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Numeric.hexStringToByteArray((String)delAddr)), new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return new RemoteCall<BaseResponse<Delegation>>(new Callable<BaseResponse<Delegation>>(){

            @Override
            public BaseResponse<Delegation> call() throws Exception {
                BaseResponse response = DelegateContract.this.executePatonCall(function);
                response.data = JSONUtil.parseObject((String)response.data, Delegation.class);
                return response;
            }
        });
    }

    public RemoteCall<BaseResponse<List<DelegationIdInfo>>> getRelatedListByDelAddr(String address) {
        final PlatOnFunction function = new PlatOnFunction(1103, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)address))));
        return new RemoteCall<BaseResponse<List<DelegationIdInfo>>>(new Callable<BaseResponse<List<DelegationIdInfo>>>(){

            @Override
            public BaseResponse<List<DelegationIdInfo>> call() throws Exception {
                BaseResponse response = DelegateContract.this.executePatonCall(function);
                response.data = JSONUtil.parseArray((String)response.data, DelegationIdInfo.class);
                return response;
            }
        });
    }
}

