/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.platon.contracts;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint32;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.platon.BaseResponse;
import org.web3j.platon.PlatOnFunction;
import org.web3j.platon.VoteOption;
import org.web3j.platon.bean.ProgramVersion;
import org.web3j.platon.bean.Proposal;
import org.web3j.platon.bean.TallyResult;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.PlatOnContract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.JSONUtil;
import org.web3j.utils.Numeric;

public class ProposalContract
extends PlatOnContract {
    public static ProposalContract load(Web3j web3j) {
        return new ProposalContract("0x1000000000000000000000000000000000000005", web3j);
    }

    public static ProposalContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new ProposalContract("0x1000000000000000000000000000000000000005", chainId, web3j, credentials);
    }

    public static ProposalContract load(Web3j web3j, TransactionManager transactionManager) {
        return new ProposalContract("0x1000000000000000000000000000000000000005", web3j, transactionManager);
    }

    private ProposalContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private ProposalContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private ProposalContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<BaseResponse<Proposal>> getProposal(String proposalId) {
        final PlatOnFunction function = new PlatOnFunction(2100, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)proposalId))));
        return new RemoteCall<BaseResponse<Proposal>>(new Callable<BaseResponse<Proposal>>(){

            @Override
            public BaseResponse<Proposal> call() throws Exception {
                BaseResponse response = ProposalContract.this.executePatonCall(function);
                response.data = JSONUtil.parseObject((String)response.data, Proposal.class);
                return response;
            }
        });
    }

    public RemoteCall<BaseResponse<TallyResult>> getTallyResult(String proposalId) {
        final PlatOnFunction function = new PlatOnFunction(2101, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)proposalId))));
        return new RemoteCall<BaseResponse<TallyResult>>(new Callable<BaseResponse<TallyResult>>(){

            @Override
            public BaseResponse<TallyResult> call() throws Exception {
                BaseResponse response = ProposalContract.this.executePatonCall(function);
                if (response.isStatusOk()) {
                    response.data = JSONUtil.parseObject((String)response.data, TallyResult.class);
                }
                return response;
            }
        });
    }

    public RemoteCall<BaseResponse<List<Proposal>>> getProposalList() {
        final PlatOnFunction function = new PlatOnFunction(2102, Arrays.asList(new Type[0]));
        return new RemoteCall<BaseResponse<List<Proposal>>>(new Callable<BaseResponse<List<Proposal>>>(){

            @Override
            public BaseResponse<List<Proposal>> call() throws Exception {
                BaseResponse response = ProposalContract.this.executePatonCall(function);
                response.data = JSONUtil.parseArray((String)response.data, Proposal.class);
                return response;
            }
        });
    }

    public RemoteCall<BaseResponse> vote(String proposalID, String verifier, VoteOption voteOption) throws Exception {
        PlatOnFunction function = this.createVoteFunction(proposalID, verifier, voteOption, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> vote(String proposalID, String verifier, VoteOption voteOption, GasProvider gasProvider) throws Exception {
        PlatOnFunction function = this.createVoteFunction(proposalID, verifier, voteOption, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getVoteProposalGasProvider(String proposalID, String verifier, VoteOption voteOption) throws Exception {
        PlatOnFunction function = this.createVoteFunction(proposalID, verifier, voteOption, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> voteReturnTransaction(String proposalID, String verifier, VoteOption voteOption) throws Exception {
        PlatOnFunction function = this.createVoteFunction(proposalID, verifier, voteOption, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> voteReturnTransaction(String proposalID, String verifier, VoteOption voteOption, GasProvider gasProvider) throws Exception {
        PlatOnFunction function = this.createVoteFunction(proposalID, verifier, voteOption, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getVoteResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 2003);
    }

    private PlatOnFunction createVoteFunction(String proposalID, String verifier, VoteOption voteOption, GasProvider gasProvider) throws Exception {
        ProgramVersion programVersion = (ProgramVersion)this.getProgramVersion().send().data;
        PlatOnFunction function = new PlatOnFunction(2003, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)verifier)), new BytesType(Numeric.hexStringToByteArray((String)proposalID)), new Uint8((long)voteOption.getValue()), new Uint32(programVersion.getProgramVersion()), new BytesType(Numeric.hexStringToByteArray((String)programVersion.getProgramVersionSign()))), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> declareVersion(String verifier) throws Exception {
        PlatOnFunction function = this.createDeclareVersionFunction(verifier, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> declareVersion(String verifier, GasProvider gasProvider) throws Exception {
        PlatOnFunction function = this.createDeclareVersionFunction(verifier, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getDeclareVersionGasProvider(String verifier) throws Exception {
        PlatOnFunction function = this.createDeclareVersionFunction(verifier, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> declareVersionReturnTransaction(String verifier) throws Exception {
        PlatOnFunction function = this.createDeclareVersionFunction(verifier, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> declareVersionReturnTransaction(String verifier, GasProvider gasProvider) throws Exception {
        PlatOnFunction function = this.createDeclareVersionFunction(verifier, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getDeclareVersionResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 2004);
    }

    private PlatOnFunction createDeclareVersionFunction(String verifier, GasProvider gasProvider) throws Exception {
        ProgramVersion processVersion = (ProgramVersion)this.getProgramVersion().send().data;
        PlatOnFunction function = new PlatOnFunction(2004, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)verifier)), new Uint32(processVersion.getProgramVersion()), new BytesType(Numeric.hexStringToByteArray((String)processVersion.getProgramVersionSign()))), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> submitProposal(Proposal proposal) {
        PlatOnFunction function = this.createSubmitProposalFunction(proposal, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> submitProposal(Proposal proposal, GasProvider gasProvider) {
        PlatOnFunction function = this.createSubmitProposalFunction(proposal, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getSubmitProposalGasProvider(Proposal proposal) {
        PlatOnFunction function = this.createSubmitProposalFunction(proposal, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> submitProposalReturnTransaction(Proposal proposal) {
        PlatOnFunction function = this.createSubmitProposalFunction(proposal, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> submitProposalReturnTransaction(Proposal proposal, GasProvider gasProvider) {
        PlatOnFunction function = this.createSubmitProposalFunction(proposal, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getSubmitProposalResult(PlatonSendTransaction ethSendTransaction, int functionType) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, functionType);
    }

    private PlatOnFunction createSubmitProposalFunction(Proposal proposal, GasProvider gasProvider) {
        if (proposal == null) {
            throw new NullPointerException("proposal must not be null");
        }
        PlatOnFunction function = new PlatOnFunction(proposal.getSubmitFunctionType(), proposal.getSubmitInputParameters(), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> getActiveVersion() {
        final PlatOnFunction function = new PlatOnFunction(2103);
        return new RemoteCall<BaseResponse>(new Callable<BaseResponse>(){

            @Override
            public BaseResponse call() throws Exception {
                return ProposalContract.this.executePatonCall(function);
            }
        });
    }

    public RemoteCall<BaseResponse<List<Proposal>>> getParamList() {
        final PlatOnFunction function = new PlatOnFunction(2105);
        return new RemoteCall<BaseResponse<List<Proposal>>>(new Callable<BaseResponse<List<Proposal>>>(){

            @Override
            public BaseResponse<List<Proposal>> call() throws Exception {
                BaseResponse response = ProposalContract.this.executePatonCall(function);
                response.data = JSONUtil.parseArray((String)response.data, Proposal.class);
                return response;
            }
        });
    }
}

