/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.platon.contracts;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Credentials;
import org.web3j.platon.BaseResponse;
import org.web3j.platon.CustomStaticArray;
import org.web3j.platon.PlatOnFunction;
import org.web3j.platon.bean.RestrictingItem;
import org.web3j.platon.bean.RestrictingPlan;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.PlatOnContract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.JSONUtil;
import org.web3j.utils.Numeric;

public class RestrictingPlanContract
extends PlatOnContract {
    public static RestrictingPlanContract load(Web3j web3j) {
        return new RestrictingPlanContract("0x1000000000000000000000000000000000000001", web3j);
    }

    public static RestrictingPlanContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new RestrictingPlanContract("0x1000000000000000000000000000000000000001", chainId, web3j, credentials);
    }

    public static RestrictingPlanContract load(Web3j web3j, TransactionManager transactionManager) {
        return new RestrictingPlanContract("0x1000000000000000000000000000000000000001", web3j, transactionManager);
    }

    private RestrictingPlanContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private RestrictingPlanContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private RestrictingPlanContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<BaseResponse> createRestrictingPlan(String account, List<RestrictingPlan> restrictingPlanList) {
        PlatOnFunction function = this.createRestrictingPlanFunction(account, restrictingPlanList, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> createRestrictingPlan(String account, List<RestrictingPlan> restrictingPlanList, GasProvider gasProvider) {
        PlatOnFunction function = this.createRestrictingPlanFunction(account, restrictingPlanList, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getCreateRestrictingPlan(String account, List<RestrictingPlan> restrictingPlanList) {
        PlatOnFunction function = this.createRestrictingPlanFunction(account, restrictingPlanList, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> createRestrictingPlanReturnTransaction(String account, List<RestrictingPlan> restrictingPlanList) {
        PlatOnFunction function = this.createRestrictingPlanFunction(account, restrictingPlanList, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> createRestrictingPlanReturnTransaction(String account, List<RestrictingPlan> restrictingPlanList, GasProvider gasProvider) {
        PlatOnFunction function = this.createRestrictingPlanFunction(account, restrictingPlanList, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getCreateRestrictingPlanResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 4000);
    }

    private PlatOnFunction createRestrictingPlanFunction(String account, List<RestrictingPlan> restrictingPlanList, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(4000, Arrays.asList(new Type[]{new BytesType(Numeric.hexStringToByteArray((String)account)), new CustomStaticArray<RestrictingPlan>(restrictingPlanList)}), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse<RestrictingItem>> getRestrictingInfo(String account) {
        final PlatOnFunction function = new PlatOnFunction(4100, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)account))));
        return new RemoteCall<BaseResponse<RestrictingItem>>(new Callable<BaseResponse<RestrictingItem>>(){

            @Override
            public BaseResponse<RestrictingItem> call() throws Exception {
                BaseResponse response = RestrictingPlanContract.this.executePatonCall(function);
                response.data = JSONUtil.parseObject((String)response.data, RestrictingItem.class);
                return response;
            }
        });
    }
}

