/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.platon.contracts;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint32;
import org.web3j.abi.datatypes.generated.Uint64;
import org.web3j.crypto.Credentials;
import org.web3j.platon.BaseResponse;
import org.web3j.platon.DuplicateSignType;
import org.web3j.platon.PlatOnFunction;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.PlatOnContract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.Numeric;

public class SlashContract
extends PlatOnContract {
    public static SlashContract load(Web3j web3j) {
        return new SlashContract("0x1000000000000000000000000000000000000004", web3j);
    }

    public static SlashContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new SlashContract("0x1000000000000000000000000000000000000004", chainId, web3j, credentials);
    }

    public static SlashContract load(Web3j web3j, TransactionManager transactionManager) {
        return new SlashContract("0x1000000000000000000000000000000000000004", web3j, transactionManager);
    }

    private SlashContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private SlashContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<BaseResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data) {
        PlatOnFunction function = this.createReportDoubleSignFunction(duplicateSignType, data, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        PlatOnFunction function = this.createReportDoubleSignFunction(duplicateSignType, data, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getReportDoubleSignGasProvider(DuplicateSignType duplicateSignType, String data) {
        PlatOnFunction function = this.createReportDoubleSignFunction(duplicateSignType, data, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data) {
        PlatOnFunction function = this.createReportDoubleSignFunction(duplicateSignType, data, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        PlatOnFunction function = this.createReportDoubleSignFunction(duplicateSignType, data, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getReportDoubleSignResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 3000);
    }

    private PlatOnFunction createReportDoubleSignFunction(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(3000, Arrays.asList(new Uint32(BigInteger.valueOf(duplicateSignType.getValue())), new Utf8String(data)), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse<String>> checkDoubleSign(DuplicateSignType doubleSignType, String address, BigInteger blockNumber) {
        final PlatOnFunction function = new PlatOnFunction(3001, Arrays.asList(new Uint32((long)doubleSignType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)address)), new Uint64(blockNumber)));
        return new RemoteCall<BaseResponse<String>>(new Callable<BaseResponse<String>>(){

            @Override
            public BaseResponse<String> call() throws Exception {
                return SlashContract.this.executePatonCall(function);
            }
        });
    }
}

