/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.platon.contracts;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.platon.BaseResponse;
import org.web3j.platon.PlatOnFunction;
import org.web3j.platon.StakingAmountType;
import org.web3j.platon.bean.Node;
import org.web3j.platon.bean.ProgramVersion;
import org.web3j.platon.bean.StakingParam;
import org.web3j.platon.bean.UpdateStakingParam;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.PlatOnContract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.JSONUtil;
import org.web3j.utils.Numeric;

public class StakingContract
extends PlatOnContract {
    public static StakingContract load(Web3j web3j) {
        return new StakingContract("0x1000000000000000000000000000000000000002", web3j);
    }

    public static StakingContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new StakingContract("0x1000000000000000000000000000000000000002", chainId, web3j, credentials);
    }

    public static StakingContract load(Web3j web3j, TransactionManager transactionManager) {
        return new StakingContract("0x1000000000000000000000000000000000000002", web3j, transactionManager);
    }

    private StakingContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private StakingContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private StakingContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<BaseResponse> staking(StakingParam stakingParam) throws Exception {
        PlatOnFunction function = this.createStakingFunction(stakingParam, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> staking(StakingParam stakingParam, GasProvider gasProvider) throws Exception {
        PlatOnFunction function = this.createStakingFunction(stakingParam, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getStakingGasProvider(StakingParam stakingParam) throws Exception {
        PlatOnFunction function = this.createStakingFunction(stakingParam, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> stakingReturnTransaction(StakingParam stakingParam) throws Exception {
        PlatOnFunction function = this.createStakingFunction(stakingParam, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> stakingReturnTransaction(StakingParam stakingParam, GasProvider gasProvider) throws Exception {
        PlatOnFunction function = this.createStakingFunction(stakingParam, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getStakingResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 1000);
    }

    private PlatOnFunction createStakingFunction(StakingParam stakingParam, GasProvider gasProvider) throws Exception {
        StakingParam tempStakingParam = stakingParam.clone();
        tempStakingParam.setProcessVersion((ProgramVersion)this.getProgramVersion().send().data);
        tempStakingParam.setBlsProof(this.web3j.getSchnorrNIZKProve().send().getAdminSchnorrNIZKProve());
        PlatOnFunction function = new PlatOnFunction(1000, tempStakingParam.getSubmitInputParameters(), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> unStaking(String nodeId) {
        PlatOnFunction function = this.createUnStakingFunction(nodeId, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> unStaking(String nodeId, GasProvider gasProvider) {
        PlatOnFunction function = this.createUnStakingFunction(nodeId, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getUnStakingGasProvider(String nodeId) {
        PlatOnFunction function = this.createUnStakingFunction(nodeId, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> unStakingReturnTransaction(String nodeId) {
        PlatOnFunction function = this.createUnStakingFunction(nodeId, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> unStakingReturnTransaction(String nodeId, GasProvider gasProvider) {
        PlatOnFunction function = this.createUnStakingFunction(nodeId, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getUnStakingResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 1003);
    }

    private PlatOnFunction createUnStakingFunction(String nodeId, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(1003, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)nodeId))), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> updateStakingInfo(UpdateStakingParam updateStakingParam) {
        PlatOnFunction function = this.createUpdateStakingFunction(updateStakingParam, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> updateStakingInfo(UpdateStakingParam updateStakingParam, GasProvider gasProvider) {
        PlatOnFunction function = this.createUpdateStakingFunction(updateStakingParam, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getUpdateStakingInfoGasProvider(UpdateStakingParam updateStakingParam) {
        PlatOnFunction function = this.createUpdateStakingFunction(updateStakingParam, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> updateStakingInfoReturnTransaction(UpdateStakingParam updateStakingParam) {
        PlatOnFunction function = this.createUpdateStakingFunction(updateStakingParam, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> updateStakingInfoReturnTransaction(UpdateStakingParam updateStakingParam, GasProvider gasProvider) {
        PlatOnFunction function = this.createUpdateStakingFunction(updateStakingParam, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getUpdateStakingInfoResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 1001);
    }

    private PlatOnFunction createUpdateStakingFunction(UpdateStakingParam updateStakingParam, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(1001, updateStakingParam.getSubmitInputParameters(), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse> addStaking(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        PlatOnFunction function = this.createAddStakingFunction(nodeId, stakingAmountType, amount, null);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public RemoteCall<BaseResponse> addStaking(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = this.createAddStakingFunction(nodeId, stakingAmountType, amount, gasProvider);
        return this.executeRemoteCallTransactionWithFunctionType(function);
    }

    public GasProvider getAddStakingGasProvider(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        PlatOnFunction function = this.createAddStakingFunction(nodeId, stakingAmountType, amount, null);
        return function.getGasProvider();
    }

    public RemoteCall<PlatonSendTransaction> addStakingReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        PlatOnFunction function = this.createAddStakingFunction(nodeId, stakingAmountType, amount, null);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<PlatonSendTransaction> addStakingReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = this.createAddStakingFunction(nodeId, stakingAmountType, amount, gasProvider);
        return this.executeRemoteCallPlatonTransaction(function);
    }

    public RemoteCall<BaseResponse> getAddStakingResult(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionWithFunctionType(ethSendTransaction, 1002);
    }

    private PlatOnFunction createAddStakingFunction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        PlatOnFunction function = new PlatOnFunction(1002, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint16((long)stakingAmountType.getValue()), new Uint256(amount)), gasProvider);
        return function;
    }

    public RemoteCall<BaseResponse<Node>> getStakingInfo(String nodeId) {
        final PlatOnFunction function = new PlatOnFunction(1105, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return new RemoteCall<BaseResponse<Node>>(new Callable<BaseResponse<Node>>(){

            @Override
            public BaseResponse<Node> call() throws Exception {
                BaseResponse response = StakingContract.this.executePatonCall(function);
                response.data = JSONUtil.parseObject((String)response.data, Node.class);
                return response;
            }
        });
    }
}

