/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.websocket.events.Notification;
import org.web3j.utils.Async;
import rx.Observable;

public abstract class Service
implements Web3jService {
    private Logger logger = LoggerFactory.getLogger(Service.class);
    protected final ObjectMapper objectMapper;

    public Service(boolean includeRawResponses) {
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
    }

    protected abstract InputStream performIO(String var1) throws IOException;

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        String payload = this.objectMapper.writeValueAsString((Object)request);
        this.logger.debug("Payload:{}", (Object)payload);
        try (InputStream result = this.performIO(payload);){
            if (result != null) {
                Response response = (Response)this.objectMapper.readValue(result, responseType);
                return (T)response;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T extends Response> CompletableFuture<T> sendAsync(Request jsonRpc20Request, Class<T> responseType) {
        return Async.run(() -> this.send(jsonRpc20Request, responseType));
    }

    @Override
    public <T extends Notification<?>> Observable<T> subscribe(Request request, String unsubscribeMethod, Class<T> responseType) {
        throw new UnsupportedOperationException(String.format("Service %s does not support subscriptions", this.getClass().getSimpleName()));
    }
}

