/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.filters.Callback;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.FilterException;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.PlatonFilter;
import org.web3j.protocol.core.methods.response.PlatonLog;

public class LogFilter
extends Filter<Log> {
    private final org.web3j.protocol.core.methods.request.PlatonFilter ethFilter;

    public LogFilter(Web3j web3j, Callback<Log> callback, org.web3j.protocol.core.methods.request.PlatonFilter ethFilter) {
        super(web3j, callback);
        this.ethFilter = ethFilter;
    }

    @Override
    PlatonFilter sendRequest() throws IOException {
        return this.web3j.platonNewFilter(this.ethFilter).send();
    }

    @Override
    void process(List<PlatonLog.LogResult> logResults) {
        for (PlatonLog.LogResult logResult : logResults) {
            if (logResult instanceof PlatonLog.LogObject) {
                Log log = ((PlatonLog.LogObject)logResult).get();
                this.callback.onEvent(log);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + " required LogObject");
        }
    }

    @Override
    protected Optional<Request<?, PlatonLog>> getFilterLogs(BigInteger filterId) {
        return Optional.of(this.web3j.platonGetFilterLogs(filterId));
    }
}

