/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.PlatOnEventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.crypto.Credentials;
import org.web3j.platon.BaseResponse;
import org.web3j.platon.PlatOnFunction;
import org.web3j.platon.bean.ProgramVersion;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.PlatonCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.ManagedTransaction;
import org.web3j.tx.RawTransactionManager;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.ContractCallException;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.JSONUtil;
import org.web3j.utils.Numeric;
import org.web3j.utils.PlatOnUtil;

public abstract class PlatOnContract
extends ManagedTransaction {
    protected String contractAddress;
    protected TransactionReceipt transactionReceipt;

    protected PlatOnContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(web3j, transactionManager);
        this.contractAddress = this.ensResolver.resolve(contractAddress);
    }

    protected PlatOnContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        this(contractAddress, web3j, new RawTransactionManager(web3j, credentials, Long.valueOf(chainId)));
    }

    protected PlatOnContract(String contractAddress, Web3j web3j) {
        this(contractAddress, web3j, new ReadonlyTransactionManager(web3j, contractAddress));
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = PlatOnUtil.invokeEncode(function);
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, encodedFunction), DefaultBlockParameterName.LATEST).send();
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    protected BaseResponse executePatonCall(PlatOnFunction function) throws IOException {
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, function.getEncodeData()), DefaultBlockParameterName.LATEST).send();
        String value = ethCall.getValue();
        BaseResponse response = JSONUtil.parseObject(new String(Numeric.hexStringToByteArray((String)value)), BaseResponse.class);
        if (response == null) {
            response = new BaseResponse();
        }
        return response;
    }

    protected BaseResponse executePatonCall(PlatOnFunction function, String contractAddress) throws IOException {
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), contractAddress, function.getEncodeData()), DefaultBlockParameterName.LATEST).send();
        String value = ethCall.getValue();
        BaseResponse response = JSONUtil.parseObject(new String(Numeric.hexStringToByteArray((String)value)), BaseResponse.class);
        if (response == null) {
            response = new BaseResponse();
        }
        return response;
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    BaseResponse executeTransaction(PlatOnFunction function, BigInteger weiValue) throws TransactionException, IOException {
        GasProvider gasProvider = function.getGasProvider();
        TransactionReceipt receipt = this.send(this.contractAddress, function.getEncodeData(), weiValue, gasProvider.getGasPrice(), gasProvider.getGasLimit());
        return this.getResponseFromTransactionReceipt(receipt, function.getType());
    }

    BaseResponse getTransactionResult(PlatonSendTransaction ethSendTransaction, int functionType) throws IOException, TransactionException {
        TransactionReceipt receipt = this.getTransactionReceipt(ethSendTransaction);
        if (!receipt.isStatusOK()) {
            throw new TransactionException(String.format("Transaction has failed with status: %s. Gas used: %d. (not-enough gas?)", receipt.getStatus(), receipt.getGasUsed()));
        }
        return this.getResponseFromTransactionReceipt(receipt, functionType);
    }

    PlatonSendTransaction executePlatonTransaction(PlatOnFunction function, BigInteger weiValue) throws TransactionException, IOException {
        GasProvider gasProvider = function.getGasProvider();
        return this.sendPlatonRawTransaction(this.contractAddress, function.getEncodeData(), weiValue, gasProvider.getGasPrice(), gasProvider.getGasLimit());
    }

    protected BaseResponse getResponseFromTransactionReceipt(TransactionReceipt transactionReceipt, int functionType) throws TransactionException {
        Event event = new Event(functionType, Arrays.asList(new TypeReference<Utf8String>(){}));
        List<EventValuesWithLog> eventValuesWithLogList = this.extractEventParametersWithLog(event, transactionReceipt);
        BaseResponse result = JSONUtil.parseObject(this.getResponseFromLog(transactionReceipt, eventValuesWithLogList), BaseResponse.class);
        result.transactionReceipt = transactionReceipt;
        return result;
    }

    private String getResponseFromLog(TransactionReceipt transactionReceipt, List<EventValuesWithLog> eventValuesWithLogList) throws TransactionException {
        List<Type> nonIndexedValues;
        boolean isEventValuesWithLogEmpty;
        boolean bl = isEventValuesWithLogEmpty = eventValuesWithLogList == null || eventValuesWithLogList.isEmpty();
        if (isEventValuesWithLogEmpty || (nonIndexedValues = eventValuesWithLogList.get(0).getNonIndexedValues()) == null || nonIndexedValues.isEmpty()) {
            throw new TransactionException(String.format("Transaction has failed with status: %s. Gas used: %d. (not-enough gas?)", transactionReceipt.getStatus(), transactionReceipt.getGasUsed()));
        }
        return (String)nonIndexedValues.get(0).getValue();
    }

    protected <T> RemoteCall<BaseResponse<T>> executePlatonRemoteCallSingleValueReturn(final PlatOnFunction function) {
        return new RemoteCall<BaseResponse<T>>(new Callable<BaseResponse<T>>(){

            @Override
            public BaseResponse<T> call() throws Exception {
                return PlatOnContract.this.executePatonCall(function);
            }
        });
    }

    protected <T extends Type> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteCall<Type>(() -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<Object>(() -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteCall<List<Type>>(() -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteCall<PlatonSendTransaction> executeRemoteCallPlatonTransaction(PlatOnFunction function, BigInteger weiValue) {
        return new RemoteCall<PlatonSendTransaction>(() -> this.executePlatonTransaction(function, weiValue));
    }

    protected RemoteCall<PlatonSendTransaction> executeRemoteCallPlatonTransaction(PlatOnFunction function) {
        return new RemoteCall<PlatonSendTransaction>(() -> this.executePlatonTransaction(function, BigInteger.ZERO));
    }

    protected RemoteCall<BaseResponse> executeRemoteCallTransactionWithFunctionType(final PlatOnFunction function, final BigInteger weiValue) {
        return new RemoteCall<BaseResponse>(new Callable<BaseResponse>(){

            @Override
            public BaseResponse call() throws Exception {
                return PlatOnContract.this.executeTransaction(function, weiValue);
            }
        });
    }

    protected RemoteCall<BaseResponse> executeRemoteCallTransactionWithFunctionType(final PlatOnFunction function) {
        return new RemoteCall<BaseResponse>(new Callable<BaseResponse>(){

            @Override
            public BaseResponse call() throws Exception {
                return PlatOnContract.this.executeTransaction(function, BigInteger.ZERO);
            }
        });
    }

    protected RemoteCall<BaseResponse> executeRemoteCallTransactionWithFunctionType(final PlatonSendTransaction ethSendTransaction, final int functionType) {
        return new RemoteCall<BaseResponse>(new Callable<BaseResponse>(){

            @Override
            public BaseResponse call() throws Exception {
                return PlatOnContract.this.getTransactionResult(ethSendTransaction, functionType);
            }
        });
    }

    public RemoteCall<BaseResponse<ProgramVersion>> getProgramVersion() {
        PlatOnFunction function = new PlatOnFunction(2104);
        return new RemoteCall<BaseResponse<ProgramVersion>>(new Callable<BaseResponse<ProgramVersion>>(){

            @Override
            public BaseResponse<ProgramVersion> call() throws Exception {
                ProgramVersion programVersion = PlatOnContract.this.web3j.getProgramVersion().send().getAdminProgramVersion();
                BaseResponse<ProgramVersion> baseResponse = new BaseResponse<ProgramVersion>();
                baseResponse.data = programVersion;
                baseResponse.code = 0;
                return baseResponse;
            }
        });
    }

    public static EventValues staticExtractEventParameters(Event event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = PlatOnEventEncoder.encodeWithFunctionType((Event)event);
        if (!topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List<Type> nonIndexedValues = PlatOnUtil.eventDecode(log.getData(), event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, Log log) {
        return PlatOnContract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        ArrayList<EventValues> list = new ArrayList<EventValues>();
        for (Log log : transactionReceipt.getLogs()) {
            EventValues eventValues = this.extractEventParameters(event, log);
            if (eventValues == null) continue;
            list.add(eventValues);
        }
        return list;
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, Log log) {
        EventValues eventValues = PlatOnContract.staticExtractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        ArrayList<EventValuesWithLog> list = new ArrayList<EventValuesWithLog>();
        for (Log log : transactionReceipt.getLogs()) {
            EventValuesWithLog eventValuesWithLog = this.extractEventParametersWithLog(event, log);
            if (eventValuesWithLog == null) continue;
            list.add(eventValuesWithLog);
        }
        return list;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final Log log;

        private EventValuesWithLog(EventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }
}

