/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.PlatOnTypeDecoder;
import org.web3j.abi.PlatOnTypeEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.IntType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Int64;
import org.web3j.platon.CustomStaticArray;
import org.web3j.platon.CustomType;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.PlatonEstimateGas;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.tx.gas.DefaultGasProvider;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class PlatOnUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"PlatOnUtil");
    private static final int MAX_DEPTH = 16;
    private static final double MAX_ITEM_LENGTH = Math.pow(256.0, 8.0);
    private static final int SIZE_THRESHOLD = 56;
    private static final int OFFSET_SHORT_ITEM = 128;
    private static final int OFFSET_LONG_ITEM = 183;
    private static final int OFFSET_SHORT_LIST = 192;
    private static final int OFFSET_LONG_LIST = 247;
    private static final String DEFAULT_ADDR = "0x0000000000000000000000000000000000000000";

    private PlatOnUtil() {
    }

    public static String invokeEncode(Function function, long txType) {
        ArrayList<RlpString> result = new ArrayList<RlpString>();
        result.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)PlatOnTypeEncoder.encode((Type)new Int64(txType)))));
        result.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)PlatOnTypeEncoder.encode((Type)new Utf8String(function.getName())))));
        List parameters = function.getInputParameters();
        for (Type parameter : parameters) {
            String encodedValue = PlatOnTypeEncoder.encode((Type)parameter);
            result.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)encodedValue)));
        }
        String data = Hex.toHexString((byte[])RlpEncoder.encode((RlpType)new RlpList(result)));
        return data;
    }

    public static String invokeEncode(Function function) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((long)function.getType()))));
        List parameters = function.getInputParameters();
        for (Type parameter : parameters) {
            if (parameter instanceof IntType) {
                result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((BigInteger)((IntType)parameter).getValue()))));
                continue;
            }
            if (parameter instanceof BytesType) {
                result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((byte[])((BytesType)parameter).getValue()))));
                continue;
            }
            if (parameter instanceof Utf8String) {
                result.add(RlpString.create((byte[])RlpEncoder.encode((RlpType)RlpString.create((String)((Utf8String)parameter).getValue()))));
                continue;
            }
            if (parameter instanceof CustomStaticArray) {
                result.add(((CustomStaticArray)parameter).getRlpEncodeData());
                continue;
            }
            if (!(parameter instanceof CustomType)) continue;
            result.add(((CustomType)parameter).getRlpEncodeData());
        }
        String data = Hex.toHexString((byte[])RlpEncoder.encode((RlpType)new RlpList(result)));
        return data;
    }

    public static String deployEncode(String contractBinary, String abi) {
        ArrayList<RlpString> result = new ArrayList<RlpString>();
        result.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)PlatOnTypeEncoder.encode((Type)new Int64(1L)))));
        result.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)contractBinary)));
        result.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)PlatOnTypeEncoder.encode((Type)new Utf8String(abi)))));
        String data = Hex.toHexString((byte[])RlpEncoder.encode((RlpType)new RlpList(result)));
        return data;
    }

    public static List<Type> eventDecode(String data, List<TypeReference<Type>> outputParameters) {
        RlpList rlpList = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)data));
        List rlpTypeList = rlpList.getValues();
        RlpList rlpList2 = (RlpList)rlpTypeList.get(0);
        ArrayList<Type> results = new ArrayList<Type>();
        for (int i = 0; i < outputParameters.size(); ++i) {
            Class type;
            RlpString rlpString = (RlpString)rlpList2.getValues().get(i);
            byte[] rlpBytes = rlpString.getBytes();
            TypeReference<Type> typeReference = outputParameters.get(i);
            try {
                type = typeReference.getClassType();
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("class not found:", e);
            }
            Type result = PlatOnTypeDecoder.decode((byte[])rlpBytes, (Class)type);
            results.add(result);
        }
        return results;
    }

    public static BigInteger estimateGasLimit(Web3j web3j, String estimateGasFrom, String estimateGasTo, String encodedData) throws IOException {
        Transaction transaction;
        Request<?, PlatonEstimateGas> ethEstimateGasReq;
        if (Strings.isEmpty((String)estimateGasTo)) {
            estimateGasTo = DEFAULT_ADDR;
        }
        if ((ethEstimateGasReq = web3j.platonEstimateGas(transaction = Transaction.createEthCallTransaction(estimateGasFrom, estimateGasTo, encodedData))) == null) {
            return DefaultGasProvider.GAS_LIMIT;
        }
        PlatonEstimateGas ethEstimateGasRes = ethEstimateGasReq.send();
        BigInteger ethEstimateGasLimit = ethEstimateGasRes.getAmountUsed();
        return ethEstimateGasLimit;
    }
}

