/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProposalUtils {
    private static Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");

    public static BigInteger versionStrToInteger(String version) {
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            int ver = Byte.parseByte(matcher.group(1)) << 16 & Integer.MAX_VALUE;
            int lite = Byte.parseByte(matcher.group(2)) << 8 & Integer.MAX_VALUE;
            int patch = Byte.parseByte(matcher.group(3)) << 0 & Integer.MAX_VALUE;
            int id = ver | lite | patch;
            return BigInteger.valueOf(id);
        }
        throw new RuntimeException("version is invalid");
    }

    public static String versionInterToStr(BigInteger version) {
        int v = version.intValue();
        int ver = v >> 16 & 0xFFFF;
        int lite = v >> 8 & 0xFF;
        int patch = v >> 0 & 0xFF;
        return String.format("%s.%s.%s", ver, lite, patch);
    }
}

