/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.web3j.codegen.Console;
import org.web3j.codegen.FunctionWrapperGenerator;
import org.web3j.codegen.SophiaFunctionWrapper;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.methods.response.AbiDefinition;
import org.web3j.utils.Collection;
import org.web3j.utils.Files;
import org.web3j.utils.Strings;
import org.web3j.utils.TXTypeEnum;

public class SophiaFunctionWrapperGenerator
extends FunctionWrapperGenerator {
    private static final String USAGE = "wasm generate [--javaTypes|--solidityTypes] <input binary file>.bin <input abi file>.abi -p|--package <base package name> -o|--output <destination base directory>-t|--txType <Transaction Type: [wasm|mpc|default]>";
    private final String binaryFileLocation;
    private final String absFileLocation;
    private final String txType;

    private SophiaFunctionWrapperGenerator(String binaryFileLocation, String absFileLocation, String destinationDirLocation, String basePackageName, String txType, boolean useJavaNativeTypes) {
        super(destinationDirLocation, basePackageName, useJavaNativeTypes);
        this.binaryFileLocation = binaryFileLocation;
        this.absFileLocation = absFileLocation;
        this.txType = txType;
    }

    public static void run(String[] args) throws Exception {
        if (args.length < 1 || !args[0].equals("generate")) {
            Console.exitError(USAGE);
        } else {
            SophiaFunctionWrapperGenerator.main(Collection.tail((String[])args));
        }
    }

    public static void main(String[] args) throws Exception {
        String[] fullArgs;
        if (args.length == 7) {
            fullArgs = new String[args.length + 1];
            fullArgs[0] = "--javaTypes";
            System.arraycopy(args, 0, fullArgs, 1, args.length);
        } else {
            fullArgs = args;
        }
        if (fullArgs.length != 9) {
            Console.exitError(USAGE);
        }
        boolean useJavaNativeTypes = SophiaFunctionWrapperGenerator.useJavaNativeTypes(fullArgs[0], USAGE);
        String binaryFileLocation = SophiaFunctionWrapperGenerator.parsePositionalArg(fullArgs, 1);
        String absFileLocation = SophiaFunctionWrapperGenerator.parsePositionalArg(fullArgs, 2);
        String destinationDirLocation = SophiaFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-o", "--outputDir");
        String basePackageName = SophiaFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-p", "--package");
        String txType = SophiaFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-t", "--txType");
        if (binaryFileLocation.equals("") || absFileLocation.equals("") || destinationDirLocation.equals("") || basePackageName.equals("") || txType.equals("")) {
            Console.exitError(USAGE);
        }
        new SophiaFunctionWrapperGenerator(binaryFileLocation, absFileLocation, destinationDirLocation, basePackageName, txType, useJavaNativeTypes).generate();
    }

    static List<AbiDefinition> loadContractDefinition(File absFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(absFile, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private void generate() throws IOException, ClassNotFoundException {
        File absFile;
        File binaryFile = new File(this.binaryFileLocation);
        if (!binaryFile.exists()) {
            Console.exitError("Invalid input binary file specified: " + this.binaryFileLocation);
        }
        if (!(absFile = new File(this.absFileLocation)).exists() || !absFile.canRead()) {
            Console.exitError("Invalid input ABI file specified: " + this.absFileLocation);
        }
        String fileName = binaryFile.getName();
        String contractName = SophiaFunctionWrapperGenerator.getFileNameNoExtension(fileName);
        byte[] bytes = Files.readBytes((File)new File(absFile.toURI()));
        String abi = new String(bytes);
        abi = abi.replaceAll("\r\n", "");
        abi = abi.replaceAll("\n", "");
        abi = abi.replaceAll(" ", "");
        List<AbiDefinition> functionDefinitions = SophiaFunctionWrapperGenerator.loadContractDefinition(absFile);
        if (functionDefinitions.isEmpty()) {
            Console.exitError("Unable to parse input ABI file");
        } else {
            String className = Strings.capitaliseFirstLetter((String)contractName);
            System.out.printf("Generating " + this.basePackageName + "." + className + " ... ", new Object[0]);
            new SophiaFunctionWrapper(this.useJavaNativeTypes, TXTypeEnum.valueOf((String)this.txType.toUpperCase())).generateJavaFiles(contractName, binaryFile, abi, this.destinationDirLocation.toString(), this.basePackageName);
            System.out.println("File written to " + this.destinationDirLocation.toString() + "\n");
        }
    }
}

