/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.console;

import java.io.File;
import java.io.IOException;
import org.web3j.codegen.Console;
import org.web3j.console.IODevice;
import org.web3j.console.WalletManager;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.WalletUtils;

public class WalletUpdater
extends WalletManager {
    public WalletUpdater() {
    }

    public WalletUpdater(IODevice console) {
        super(console);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Console.exitError((String)"You must provide an existing wallet file");
        } else {
            new WalletUpdater().run(args[0]);
        }
    }

    public static void main(IODevice console, String walletFileLocation) {
        new WalletUpdater(console).run(walletFileLocation);
    }

    private void run(String walletFileLocation) {
        File walletFile = new File(walletFileLocation);
        Credentials credentials = this.getCredentials(walletFile);
        this.console.printf("Wallet for address " + credentials.getAddress() + " loaded\n", new Object[0]);
        String newPassword = this.getPassword("Please enter a new wallet file password: ");
        String destinationDir = this.getDestinationDir();
        File destination = this.createDir(destinationDir);
        try {
            String walletFileName = WalletUtils.generateWalletFile((String)newPassword, (ECKeyPair)credentials.getEcKeyPair(), (File)destination, (boolean)true);
            this.console.printf("New wallet file " + walletFileName + " successfully created in: " + destinationDir + "\n", new Object[0]);
        }
        catch (IOException | CipherException e) {
            Console.exitError((Throwable)e);
        }
        String delete = this.console.readLine("Would you like to delete your existing wallet file (Y/N)? [N]: ", new Object[0]);
        if (delete.toUpperCase().equals("Y")) {
            if (!walletFile.delete()) {
                Console.exitError((String)"Unable to remove wallet file\n");
            } else {
                this.console.printf("Deleted previous wallet file: %s\n", walletFile.getName());
            }
        }
    }
}

