/*
 * Decompiled with CFR 0.152.
 */
package com.platon.sdk.contracts.ppos;

import com.alibaba.fastjson.annotation.JSONField;
import com.platon.sdk.contracts.ppos.abi.Function;
import com.platon.sdk.contracts.ppos.dto.CallResponse;
import com.platon.sdk.contracts.ppos.dto.TransactionResponse;
import com.platon.sdk.contracts.ppos.exception.NoSupportFunctionType;
import com.platon.sdk.contracts.ppos.utils.EncoderUtils;
import com.platon.sdk.contracts.ppos.utils.EstimateGasUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.crypto.Credentials;
import org.web3j.exceptions.MessageDecodingException;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.PlatonCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.tx.ManagedTransaction;
import org.web3j.tx.RawTransactionManager;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.ContractCallException;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.JSONUtil;
import org.web3j.utils.Numeric;

public abstract class BaseContract
extends ManagedTransaction {
    protected String contractAddress;
    protected TransactionReceipt transactionReceipt;

    protected BaseContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(web3j, transactionManager);
        this.contractAddress = this.ensResolver.resolve(contractAddress);
    }

    protected BaseContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        this(contractAddress, web3j, new RawTransactionManager(web3j, credentials, Long.valueOf(chainId)));
    }

    protected BaseContract(String contractAddress, Web3j web3j) {
        this(contractAddress, web3j, new ReadonlyTransactionManager(web3j, contractAddress));
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    protected <T> RemoteCall<CallResponse<T>> executeRemoteCallObjectValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<CallResponse<T>>(() -> this.executeCallObjectValueReturn(function, returnType));
    }

    protected <T> RemoteCall<CallResponse<List<T>>> executeRemoteCallListValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<CallResponse<List<T>>>(() -> this.executeCallListValueReturn(function, returnType));
    }

    private <T> CallResponse<T> executeCallObjectValueReturn(Function function, Class<T> returnType) throws IOException {
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, EncoderUtils.functionEncoder(function)), DefaultBlockParameterName.LATEST).send();
        String result = Numeric.cleanHexPrefix((String)ethCall.getValue());
        if (result == null || "".equals(result)) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        CallRet callRet = JSONUtil.parseObject(new String(Hex.decode((String)result)), CallRet.class);
        if (callRet == null) {
            throw new ContractCallException("Unable to convert response: " + result);
        }
        CallResponse<BigInteger> callResponse = new CallResponse<BigInteger>();
        if (callRet.isStatusOk()) {
            callResponse.setCode(callRet.getCode());
            if (BigInteger.class.isAssignableFrom(returnType)) {
                callResponse.setData(this.numberDecoder(callRet.getRet()));
            } else {
                callResponse.setData((BigInteger)JSONUtil.parseObject(JSONUtil.toJSONString(callRet.getRet()), returnType));
            }
        } else {
            callResponse.setCode(callRet.getCode());
            callResponse.setErrMsg(callRet.getRet().toString());
        }
        return callResponse;
    }

    private BigInteger numberDecoder(Object number) {
        if (number instanceof String) {
            String numberStr = (String)number;
            return Numeric.decodeQuantity((String)numberStr);
        }
        if (number instanceof Number) {
            Number number2 = (Number)number;
            return BigInteger.valueOf(number2.longValue());
        }
        throw new MessageDecodingException("Can not decode number value = " + number);
    }

    private <T> CallResponse<List<T>> executeCallListValueReturn(Function function, Class<T> returnType) throws IOException {
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, EncoderUtils.functionEncoder(function)), DefaultBlockParameterName.LATEST).send();
        String result = Numeric.cleanHexPrefix((String)ethCall.getValue());
        if (result == null || "".equals(result)) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        CallRet callRet = JSONUtil.parseObject(new String(Hex.decode((String)result)), CallRet.class);
        if (callRet == null) {
            throw new ContractCallException("Unable to convert response: " + result);
        }
        CallResponse callResponse = new CallResponse();
        if (callRet.isStatusOk()) {
            callResponse.setCode(callRet.getCode());
            callResponse.setData(JSONUtil.parseArray(JSONUtil.toJSONString(callRet.getRet()), returnType));
        } else {
            callResponse.setCode(callRet.getCode());
            callResponse.setErrMsg(callRet.getRet().toString());
        }
        if (callRet.getCode() == 2) {
            callResponse.setCode(0);
            callResponse.setData(Collections.emptyList());
        }
        return callResponse;
    }

    protected RemoteCall<PlatonSendTransaction> executeRemoteCallTransactionStep1(Function function, GasProvider gasProvider) {
        return new RemoteCall<PlatonSendTransaction>(() -> this.executeTransactionStep1(function, BigInteger.ZERO, gasProvider));
    }

    protected RemoteCall<PlatonSendTransaction> executeRemoteCallTransactionStep1(Function function) {
        return new RemoteCall<PlatonSendTransaction>(() -> this.executeTransactionStep1(function, BigInteger.ZERO, this.getDefaultGasProvider(function)));
    }

    private RemoteCall<TransactionResponse> executeRemoteCallTransactionStep2(PlatonSendTransaction ethSendTransaction) {
        return new RemoteCall<TransactionResponse>(() -> this.executeTransactionStep2(ethSendTransaction));
    }

    public RemoteCall<TransactionResponse> getTransactionResponse(PlatonSendTransaction ethSendTransaction) throws IOException, TransactionException {
        return this.executeRemoteCallTransactionStep2(ethSendTransaction);
    }

    protected RemoteCall<TransactionResponse> executeRemoteCallTransaction(Function function) {
        return new RemoteCall<TransactionResponse>(() -> this.executeTransaction(function, BigInteger.ZERO, this.getDefaultGasProvider(function)));
    }

    protected RemoteCall<TransactionResponse> executeRemoteCallTransaction(Function function, GasProvider gasProvider) {
        return new RemoteCall<TransactionResponse>(() -> this.executeTransaction(function, BigInteger.ZERO, gasProvider));
    }

    protected GasProvider getDefaultGasProvider(Function function) throws IOException, NoSupportFunctionType {
        if (EstimateGasUtil.isSupportLocal(function.getType())) {
            return this.getDefaultGasProviderLocal(function);
        }
        return this.getDefaultGasProviderRemote(function);
    }

    private GasProvider getDefaultGasProviderRemote(Function function) throws IOException {
        Transaction transaction = Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, EncoderUtils.functionEncoder(function));
        BigInteger gasLimit = this.web3j.platonEstimateGas(transaction).send().getAmountUsed();
        BigInteger gasPrice = this.getDefaultGasPrice(function.getType());
        ContractGasProvider gasProvider = new ContractGasProvider(gasPrice, gasLimit);
        return gasProvider;
    }

    private GasProvider getDefaultGasProviderLocal(Function function) throws IOException, NoSupportFunctionType {
        BigInteger gasLimit = EstimateGasUtil.getGasLimit(function);
        BigInteger gasPrice = this.getDefaultGasPrice(function.getType());
        ContractGasProvider gasProvider = new ContractGasProvider(gasPrice, gasLimit);
        return gasProvider;
    }

    private BigInteger getDefaultGasPrice(int type) throws IOException {
        switch (type) {
            case 2000: {
                return BigInteger.valueOf(1500000L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2001: {
                return BigInteger.valueOf(0x200B20L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2002: {
                return BigInteger.valueOf(2000000L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2005: {
                return BigInteger.valueOf(3000000L).multiply(BigInteger.valueOf(1000000000L));
            }
        }
        return this.web3j.platonGasPrice().send().getGasPrice();
    }

    private TransactionResponse executeTransaction(Function function, BigInteger weiValue, GasProvider gasProvider) throws TransactionException, IOException {
        TransactionReceipt receipt = this.send(this.contractAddress, EncoderUtils.functionEncoder(function), weiValue, gasProvider.getGasPrice(), gasProvider.getGasLimit());
        return this.getResponseFromTransactionReceipt(receipt);
    }

    private PlatonSendTransaction executeTransactionStep1(Function function, BigInteger weiValue, GasProvider gasProvider) throws TransactionException, IOException {
        PlatonSendTransaction sendTransaction = this.sendPlatonRawTransaction(this.contractAddress, EncoderUtils.functionEncoder(function), weiValue, gasProvider.getGasPrice(), gasProvider.getGasLimit());
        return sendTransaction;
    }

    private TransactionResponse executeTransactionStep2(PlatonSendTransaction ethSendTransaction) throws IOException, TransactionException {
        TransactionReceipt receipt = this.getTransactionReceipt(ethSendTransaction);
        return this.getResponseFromTransactionReceipt(receipt);
    }

    private TransactionResponse getResponseFromTransactionReceipt(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt log data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        TransactionResponse transactionResponse = new TransactionResponse();
        transactionResponse.setCode(statusCode);
        transactionResponse.setTransactionReceipt(transactionReceipt);
        return transactionResponse;
    }

    public static class CallRet {
        @JSONField(name="Code")
        private int code;
        @JSONField(name="Ret")
        private Object ret;

        public boolean isStatusOk() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public Object getRet() {
            return this.ret;
        }

        public void setRet(Object ret) {
            this.ret = ret;
        }

        public String toString() {
            return "CallRet [code=" + this.code + ", ret=" + this.ret + "]";
        }
    }
}

