/*
 * Decompiled with CFR 0.152.
 */
package com.platon.sdk.contracts.ppos;

import com.platon.sdk.contracts.ppos.BaseContract;
import com.platon.sdk.contracts.ppos.abi.CustomStaticArray;
import com.platon.sdk.contracts.ppos.abi.Function;
import com.platon.sdk.contracts.ppos.abi.custom.NodeId;
import com.platon.sdk.contracts.ppos.dto.CallResponse;
import com.platon.sdk.contracts.ppos.dto.TransactionResponse;
import com.platon.sdk.contracts.ppos.dto.resp.Reward;
import com.platon.sdk.contracts.ppos.exception.NoSupportFunctionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.Numeric;

public class RewardContract
extends BaseContract {
    public static RewardContract load(Web3j web3j) {
        return new RewardContract("0x1000000000000000000000000000000000000006", web3j);
    }

    public static RewardContract load(Web3j web3j, TransactionManager transactionManager) {
        return new RewardContract("0x1000000000000000000000000000000000000006", web3j, transactionManager);
    }

    public static RewardContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new RewardContract("0x1000000000000000000000000000000000000006", chainId, web3j, credentials);
    }

    private RewardContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private RewardContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private RewardContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> withdrawDelegateReward() {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> withdrawDelegateReward(GasProvider gasProvider) {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getWithdrawDelegateRewardGasProvider() throws IOException, NoSupportFunctionType {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> withdrawDelegateRewardReturnTransaction() {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> withdrawDelegateRewardReturnTransaction(GasProvider gasProvider) {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createWithdrawDelegateRewardFunction() {
        Function function = new Function(5000);
        return function;
    }

    public List<Reward> decodeWithdrawDelegateRewardLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt logs[0].data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        if (statusCode != 0) {
            throw new TransactionException("TransactionResponse code is 0");
        }
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        ((RlpList)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).getValues().stream().forEach(rl -> {
            RlpList rlpL = (RlpList)rl;
            Reward reward = new Reward();
            reward.setNodeId(((RlpString)rlpL.getValues().get(0)).asString());
            reward.setStakingNum(((RlpString)rlpL.getValues().get(1)).asPositiveBigInteger());
            reward.setRewardBigIntegerValue(((RlpString)rlpL.getValues().get(2)).asPositiveBigInteger());
            rewards.add(reward);
        });
        return rewards;
    }

    public RemoteCall<CallResponse<List<Reward>>> getDelegateReward(String address, List<String> nodeList) {
        List bytesTypeList = nodeList.stream().map(nodeId -> new NodeId((String)nodeId)).collect(Collectors.toList());
        CustomStaticArray dynamicArray = new CustomStaticArray(bytesTypeList);
        Function function = new Function(5100, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)address)), dynamicArray));
        return this.executeRemoteCallListValueReturn(function, Reward.class);
    }
}

