/*
 * Decompiled with CFR 0.152.
 */
package com.platon.sdk.contracts.ppos;

import com.platon.sdk.contracts.ppos.BaseContract;
import com.platon.sdk.contracts.ppos.abi.Function;
import com.platon.sdk.contracts.ppos.dto.CallResponse;
import com.platon.sdk.contracts.ppos.dto.TransactionResponse;
import com.platon.sdk.contracts.ppos.dto.common.DuplicateSignType;
import com.platon.sdk.contracts.ppos.exception.NoSupportFunctionType;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint32;
import org.web3j.abi.datatypes.generated.Uint64;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.Numeric;

public class SlashContract
extends BaseContract {
    public static SlashContract load(Web3j web3j) {
        return new SlashContract("0x1000000000000000000000000000000000000004", web3j);
    }

    public static SlashContract load(Web3j web3j, TransactionManager transactionManager) {
        return new SlashContract("0x1000000000000000000000000000000000000004", web3j, transactionManager);
    }

    public static SlashContract load(Web3j web3j, Credentials credentials, String chainId) {
        return new SlashContract("0x1000000000000000000000000000000000000004", chainId, web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private SlashContract(String contractAddress, String chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getReportDoubleSignGasProvider(DuplicateSignType duplicateSignType, String data) throws IOException, NoSupportFunctionType {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createReportDoubleSignFunction(DuplicateSignType duplicateSignType, String data) {
        Function function = new Function(3000, Arrays.asList(new Uint32(BigInteger.valueOf(duplicateSignType.getValue())), new Utf8String(data)));
        return function;
    }

    public RemoteCall<CallResponse<String>> checkDoubleSign(DuplicateSignType doubleSignType, String address, BigInteger blockNumber) {
        Function function = new Function(3001, Arrays.asList(new Uint32((long)doubleSignType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)address)), new Uint64(blockNumber)));
        return this.executeRemoteCallObjectValueReturn(function, String.class);
    }
}

