/*
 * Decompiled with CFR 0.152.
 */
package com.platon.sdk.contracts.ppos.dto.req;

import com.platon.sdk.contracts.ppos.dto.enums.StakingAmountType;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Int256;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint32;
import org.web3j.platon.bean.ProgramVersion;
import org.web3j.utils.Numeric;

public class StakingParam
implements Cloneable {
    private String nodeId;
    private BigInteger amount;
    private StakingAmountType stakingAmountType;
    private String benifitAddress;
    private String externalId;
    private String nodeName;
    private String webSite;
    private String details;
    private ProgramVersion processVersion;
    private String blsPubKey;
    private String blsProof;
    private BigInteger rewardPer;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public StakingAmountType getStakingAmountType() {
        return this.stakingAmountType;
    }

    public void setStakingAmountType(StakingAmountType stakingAmountType) {
        this.stakingAmountType = stakingAmountType;
    }

    public String getBenifitAddress() {
        return this.benifitAddress;
    }

    public void setBenifitAddress(String benifitAddress) {
        this.benifitAddress = benifitAddress;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public void setWebSite(String webSite) {
        this.webSite = webSite;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public ProgramVersion getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(ProgramVersion processVersion) {
        this.processVersion = processVersion;
    }

    public String getBlsPubKey() {
        return this.blsPubKey;
    }

    public void setBlsPubKey(String blsPubKey) {
        this.blsPubKey = blsPubKey;
    }

    public String getBlsProof() {
        return this.blsProof;
    }

    public void setBlsProof(String blsProof) {
        this.blsProof = blsProof;
    }

    public BigInteger getRewardPer() {
        return this.rewardPer;
    }

    public void setRewardPer(BigInteger rewardPer) {
        this.rewardPer = rewardPer;
    }

    public StakingParam(Builder builder) {
        this.nodeId = builder.nodeId;
        this.amount = builder.amount;
        this.stakingAmountType = builder.stakingAmountType;
        this.benifitAddress = builder.benifitAddress;
        this.externalId = builder.externalId;
        this.nodeName = builder.nodeName;
        this.webSite = builder.webSite;
        this.details = builder.details;
        this.processVersion = builder.processVersion;
        this.blsPubKey = builder.blsPubKey;
        this.blsProof = builder.blsProof;
        this.rewardPer = builder.rewardPer;
    }

    public List<Type> getSubmitInputParameters() {
        return Arrays.asList(new Uint16((long)this.stakingAmountType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)this.benifitAddress)), new BytesType(Numeric.hexStringToByteArray((String)this.nodeId)), new Utf8String(this.externalId), new Utf8String(this.nodeName), new Utf8String(this.webSite), new Utf8String(this.details), new Int256(this.amount), new Uint16(this.rewardPer), new Uint32(this.processVersion.getProgramVersion()), new BytesType(Numeric.hexStringToByteArray((String)this.processVersion.getProgramVersionSign())), new BytesType(Numeric.hexStringToByteArray((String)this.blsPubKey)), new BytesType(Numeric.hexStringToByteArray((String)this.blsProof)));
    }

    public StakingParam clone() {
        StakingParam stakingParam = null;
        try {
            stakingParam = (StakingParam)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return stakingParam;
    }

    public static final class Builder {
        private String nodeId;
        private BigInteger amount;
        private StakingAmountType stakingAmountType;
        private String benifitAddress;
        private String externalId;
        private String nodeName;
        private String webSite;
        private String details;
        private ProgramVersion processVersion;
        private String blsPubKey;
        private String blsProof;
        private BigInteger rewardPer;

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setAmount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public Builder setStakingAmountType(StakingAmountType stakingAmountType) {
            this.stakingAmountType = stakingAmountType;
            return this;
        }

        public Builder setBenifitAddress(String benifitAddress) {
            this.benifitAddress = benifitAddress;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder setNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public Builder setWebSite(String webSite) {
            this.webSite = webSite;
            return this;
        }

        public Builder setDetails(String details) {
            this.details = details;
            return this;
        }

        public Builder setProcessVersion(ProgramVersion processVersion) {
            this.processVersion = processVersion;
            return this;
        }

        public Builder setBlsPubKey(String blsPubKey) {
            this.blsPubKey = blsPubKey;
            return this;
        }

        public Builder setBlsProof(String blsProof) {
            this.blsProof = blsProof;
            return this;
        }

        public Builder setRewardPer(BigInteger rewardPer) {
            this.rewardPer = rewardPer;
            return this;
        }

        public StakingParam build() {
            return new StakingParam(this);
        }
    }
}

