/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.PlatonGetTransactionCount;
import org.web3j.protocol.core.methods.response.PlatonSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.TxHashMismatchException;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;
import org.web3j.utils.TxHashVerifier;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    private final long chainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials) {
        this(web3j, credentials, -1L);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        this(web3j, credentials, -1L, attempts, sleepDuration);
    }

    protected BigInteger getNonce() throws IOException {
        PlatonGetTransactionCount ethGetTransactionCount = this.web3j.platonGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.PENDING).send();
        if (ethGetTransactionCount.getTransactionCount().intValue() == 0) {
            ethGetTransactionCount = this.web3j.platonGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.LATEST).send();
        }
        return ethGetTransactionCount.getTransactionCount();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public PlatonSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    public PlatonSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        byte[] signedMessage = this.chainId > -1L ? TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)this.chainId, (Credentials)this.credentials) : TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        PlatonSendTransaction ethSendTransaction = this.web3j.platonSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3((String)hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }
}

