/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.crypto.params.KeyParameter;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.SecureRandomUtils;
import org.web3j.crypto.WalletFile;
import org.web3j.utils.Numeric;

public class Wallet {
    private static final int N_LIGHT = 4096;
    private static final int P_LIGHT = 6;
    private static final int N_STANDARD = 262144;
    private static final int P_STANDARD = 1;
    private static final int N_PLATON = 16384;
    private static final int P_PLATON = 1;
    private static final int R = 8;
    private static final int DKLEN = 32;
    private static final int CURRENT_VERSION = 3;
    private static final String CIPHER = "aes-128-ctr";
    static final String AES_128_CTR = "pbkdf2";
    static final String SCRYPT = "scrypt";

    public static WalletFile create(String password, ECKeyPair ecKeyPair, int n, int p) throws CipherException {
        byte[] salt = Wallet.generateRandomBytes(32);
        byte[] derivedKey = Wallet.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, 8, p, 32);
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        byte[] iv = Wallet.generateRandomBytes(16);
        byte[] privateKeyBytes = Numeric.toBytesPadded((BigInteger)ecKeyPair.getPrivateKey(), (int)32);
        byte[] cipherText = Wallet.performCipherOperation(1, iv, encryptKey, privateKeyBytes);
        byte[] mac = Wallet.generateMac(derivedKey, cipherText);
        return Wallet.createWalletFile(ecKeyPair, cipherText, iv, salt, mac, n, p);
    }

    public static WalletFile createStandard(String password, ECKeyPair ecKeyPair) throws CipherException {
        return Wallet.create(password, ecKeyPair, 262144, 1);
    }

    public static WalletFile createLight(String password, ECKeyPair ecKeyPair) throws CipherException {
        return Wallet.create(password, ecKeyPair, 4096, 6);
    }

    public static WalletFile createPlatON(String password, ECKeyPair ecKeyPair) throws CipherException {
        return Wallet.create(password, ecKeyPair, 16384, 1);
    }

    private static WalletFile createWalletFile(ECKeyPair ecKeyPair, byte[] cipherText, byte[] iv, byte[] salt, byte[] mac, int n, int p) {
        WalletFile walletFile = new WalletFile();
        walletFile.setAddress(Keys.getAddress(ecKeyPair));
        WalletFile.Crypto crypto = new WalletFile.Crypto();
        crypto.setCipher(CIPHER);
        crypto.setCiphertext(Numeric.toHexStringNoPrefix((byte[])cipherText));
        WalletFile.CipherParams cipherParams = new WalletFile.CipherParams();
        cipherParams.setIv(Numeric.toHexStringNoPrefix((byte[])iv));
        crypto.setCipherparams(cipherParams);
        crypto.setKdf(SCRYPT);
        WalletFile.ScryptKdfParams kdfParams = new WalletFile.ScryptKdfParams();
        kdfParams.setDklen(32);
        kdfParams.setN(n);
        kdfParams.setP(p);
        kdfParams.setR(8);
        kdfParams.setSalt(Numeric.toHexStringNoPrefix((byte[])salt));
        crypto.setKdfparams(kdfParams);
        crypto.setMac(Numeric.toHexStringNoPrefix((byte[])mac));
        walletFile.setCrypto(crypto);
        walletFile.setId(UUID.randomUUID().toString());
        walletFile.setVersion(3);
        return walletFile;
    }

    private static byte[] generateDerivedScryptKey(byte[] password, byte[] salt, int n, int r, int p, int dkLen) throws CipherException {
        return SCrypt.generate((byte[])password, (byte[])salt, (int)n, (int)r, (int)p, (int)dkLen);
    }

    private static byte[] generateAes128CtrDerivedKey(byte[] password, byte[] salt, int c, String prf) throws CipherException {
        if (!prf.equals("hmac-sha256")) {
            throw new CipherException("Unsupported prf:" + prf);
        }
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(password, salt, c);
        return ((KeyParameter)gen.generateDerivedParameters(256)).getKey();
    }

    private static byte[] performCipherOperation(int mode, byte[] iv, byte[] encryptKey, byte[] text) throws CipherException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
            cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(text);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CipherException("Error performing cipher operation", e);
        }
    }

    private static byte[] generateMac(byte[] derivedKey, byte[] cipherText) {
        byte[] result = new byte[16 + cipherText.length];
        System.arraycopy(derivedKey, 16, result, 0, 16);
        System.arraycopy(cipherText, 0, result, 16, cipherText.length);
        return Hash.sha3((byte[])result);
    }

    public static ECKeyPair decrypt(String password, WalletFile walletFile) throws CipherException {
        byte[] derivedKey;
        Wallet.validate(walletFile);
        WalletFile.Crypto crypto = walletFile.getCrypto();
        byte[] mac = Numeric.hexStringToByteArray((String)crypto.getMac());
        byte[] iv = Numeric.hexStringToByteArray((String)crypto.getCipherparams().getIv());
        byte[] cipherText = Numeric.hexStringToByteArray((String)crypto.getCiphertext());
        WalletFile.KdfParams kdfParams = crypto.getKdfparams();
        if (kdfParams instanceof WalletFile.ScryptKdfParams) {
            WalletFile.ScryptKdfParams scryptKdfParams = (WalletFile.ScryptKdfParams)crypto.getKdfparams();
            int dklen = scryptKdfParams.getDklen();
            int n = scryptKdfParams.getN();
            int p = scryptKdfParams.getP();
            int r = scryptKdfParams.getR();
            byte[] salt = Numeric.hexStringToByteArray((String)scryptKdfParams.getSalt());
            derivedKey = Wallet.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, r, p, dklen);
        } else if (kdfParams instanceof WalletFile.Aes128CtrKdfParams) {
            WalletFile.Aes128CtrKdfParams aes128CtrKdfParams = (WalletFile.Aes128CtrKdfParams)crypto.getKdfparams();
            int c = aes128CtrKdfParams.getC();
            String prf = aes128CtrKdfParams.getPrf();
            byte[] salt = Numeric.hexStringToByteArray((String)aes128CtrKdfParams.getSalt());
            derivedKey = Wallet.generateAes128CtrDerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, c, prf);
        } else {
            throw new CipherException("Unable to deserialize params: " + crypto.getKdf());
        }
        byte[] derivedMac = Wallet.generateMac(derivedKey, cipherText);
        if (!Arrays.equals(derivedMac, mac)) {
            throw new CipherException("Invalid password provided");
        }
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        byte[] privateKey = Wallet.performCipherOperation(2, iv, encryptKey, cipherText);
        return ECKeyPair.create(privateKey);
    }

    static void validate(WalletFile walletFile) throws CipherException {
        WalletFile.Crypto crypto = walletFile.getCrypto();
        if (walletFile.getVersion() != 3) {
            throw new CipherException("Wallet version is not supported");
        }
        if (!crypto.getCipher().equals(CIPHER)) {
            throw new CipherException("Wallet cipher is not supported");
        }
        if (!crypto.getKdf().equals(AES_128_CTR) && !crypto.getKdf().equals(SCRYPT)) {
            throw new CipherException("KDF type is not supported");
        }
    }

    static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SecureRandomUtils.secureRandom().nextBytes(bytes);
        return bytes;
    }
}

