/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.Log;

public class PlatonLog
extends Response<List<LogResult>> {
    @Override
    @JsonDeserialize(using=LogResultDeserialiser.class)
    public void setResult(List<LogResult> result) {
        super.setResult(result);
    }

    public List<LogResult> getLogs() {
        return (List)this.getResult();
    }

    public static class LogResultDeserialiser
    extends JsonDeserializer<List<LogResult>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<LogResult> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<LogResult> logResults;
            block3: {
                JsonToken nextToken;
                block2: {
                    logResults = new ArrayList<LogResult>();
                    nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator logObjectIterator = this.objectReader.readValues(jsonParser, LogObject.class);
                    while (logObjectIterator.hasNext()) {
                        logResults.add((LogResult)logObjectIterator.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                jsonParser.getValueAsString();
                Iterator transactionHashIterator = this.objectReader.readValues(jsonParser, Hash.class);
                while (transactionHashIterator.hasNext()) {
                    logResults.add((LogResult)transactionHashIterator.next());
                }
            }
            return logResults;
        }
    }

    public static class Hash
    implements LogResult<String> {
        private String value;

        public Hash() {
        }

        public Hash(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Hash)) {
                return false;
            }
            Hash hash = (Hash)o;
            return this.value != null ? this.value.equals(hash.value) : hash.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class LogObject
    extends Log
    implements LogResult<Log> {
        public LogObject() {
        }

        public LogObject(boolean removed, String logIndex, String transactionIndex, String transactionHash, String blockHash, String blockNumber, String address, String data, String type, List<String> topics) {
            super(removed, logIndex, transactionIndex, transactionHash, blockHash, blockNumber, address, data, type, topics);
        }

        @Override
        public Log get() {
            return this;
        }
    }

    public static interface LogResult<T> {
        public T get();
    }
}

