/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.console;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.web3j.codegen.Console;
import org.web3j.console.IODevice;
import org.web3j.console.WalletManager;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.WalletUtils;

public class WalletCreator
extends WalletManager {
    public WalletCreator() {
    }

    public WalletCreator(IODevice console) {
        super(console);
    }

    public static void main(String[] args) {
        new WalletCreator().run();
    }

    static void main(IODevice console) {
        new WalletCreator(console).run();
    }

    private void run() {
        String password = this.getPassword("Please enter a wallet file password: ");
        String destinationDir = this.getDestinationDir();
        File destination = this.createDir(destinationDir);
        try {
            String walletFileName = WalletUtils.generateFullNewWalletFile((String)password, (File)destination);
            this.console.printf("Wallet file " + walletFileName + " successfully created in: " + destinationDir + "\n", new Object[0]);
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | CipherException e) {
            Console.exitError((Throwable)e);
        }
    }
}

