/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.web3j.crypto.MnemonicUtils;

@RunWith(value=Parameterized.class)
public class MnemonicUtilsTest {
    private static final String SAMPLE_FILE = "build/resources/test/mnemonics/test-vectors.txt";
    private byte[] initialEntropy;
    private String mnemonic;
    private byte[] seed;

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException {
        String data = Files.lines(Paths.get(SAMPLE_FILE, new String[0])).collect(Collectors.joining("\n"));
        String[] each = data.split("###");
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (String part : each) {
            parameters.add(part.trim().split("\n"));
        }
        return parameters;
    }

    public MnemonicUtilsTest(String initialEntropy, String mnemonic, String seed) {
        this.initialEntropy = Hex.decode((String)initialEntropy);
        this.mnemonic = mnemonic;
        this.seed = Hex.decode((String)seed);
    }

    @Test
    public void generateMnemonicShouldGenerateExpectedMnemonicWords() {
        String actualMnemonic = MnemonicUtils.generateMnemonic((byte[])this.initialEntropy);
        Assert.assertEquals((Object)this.mnemonic, (Object)actualMnemonic);
    }

    @Test
    public void generateSeedShouldGenerateExpectedSeeds() {
        byte[] actualSeed = MnemonicUtils.generateSeed((String)this.mnemonic, (String)"TREZOR");
        Assert.assertArrayEquals((byte[])this.seed, (byte[])actualSeed);
    }

    @Test
    public void generateEntropyShouldGenerateExpectedEntropy() {
        byte[] actualEntropy = MnemonicUtils.generateEntropy((String)this.mnemonic);
        Assert.assertArrayEquals((byte[])this.initialEntropy, (byte[])actualEntropy);
    }
}

