/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.SampleKeys;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.TransactionDecoder;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.utils.Numeric;

public class TransactionDecoderTest {
    @Test
    public void testDecoding() throws Exception {
        BigInteger nonce = BigInteger.ZERO;
        BigInteger gasPrice = BigInteger.ONE;
        BigInteger gasLimit = BigInteger.TEN;
        String to = "0x0add5355";
        BigInteger value = BigInteger.valueOf(Long.MAX_VALUE);
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value);
        byte[] encodedMessage = TransactionEncoder.encode((RawTransaction)rawTransaction);
        String hexMessage = Numeric.toHexString((byte[])encodedMessage);
        RawTransaction result = TransactionDecoder.decode((String)hexMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)nonce, (Object)result.getNonce());
        Assert.assertEquals((Object)gasPrice, (Object)result.getGasPrice());
        Assert.assertEquals((Object)gasLimit, (Object)result.getGasLimit());
        Assert.assertEquals((Object)to, (Object)result.getTo());
        Assert.assertEquals((Object)value, (Object)result.getValue());
        Assert.assertEquals((Object)"", (Object)result.getData());
    }

    @Test
    public void testDecodingSigned() throws Exception {
        BigInteger nonce = BigInteger.ZERO;
        BigInteger gasPrice = BigInteger.ONE;
        BigInteger gasLimit = BigInteger.TEN;
        String to = "0x0add5355";
        BigInteger value = BigInteger.valueOf(Long.MAX_VALUE);
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)SampleKeys.CREDENTIALS);
        String hexMessage = Numeric.toHexString((byte[])signedMessage);
        RawTransaction result = TransactionDecoder.decode((String)hexMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)nonce, (Object)result.getNonce());
        Assert.assertEquals((Object)gasPrice, (Object)result.getGasPrice());
        Assert.assertEquals((Object)gasLimit, (Object)result.getGasLimit());
        Assert.assertEquals((Object)to, (Object)result.getTo());
        Assert.assertEquals((Object)value, (Object)result.getValue());
        Assert.assertEquals((Object)"", (Object)result.getData());
        Assert.assertTrue((boolean)(result instanceof SignedRawTransaction));
        SignedRawTransaction signedResult = (SignedRawTransaction)result;
        Assert.assertNotNull((Object)signedResult.getSignatureData());
        Sign.SignatureData signatureData = signedResult.getSignatureData();
        byte[] encodedTransaction = TransactionEncoder.encode((RawTransaction)rawTransaction);
        BigInteger key = Sign.signedMessageToKey((byte[])encodedTransaction, (Sign.SignatureData)signatureData);
        Assert.assertEquals((Object)key, (Object)SampleKeys.PUBLIC_KEY);
        Assert.assertEquals((Object)"0xef678007d18427e6022059dbc264f27507cd1ffc", (Object)signedResult.getFrom());
        signedResult.verify("0xef678007d18427e6022059dbc264f27507cd1ffc");
        Assert.assertNull((Object)signedResult.getChainId());
    }

    @Test
    public void testDecodingSignedChainId() throws Exception {
        BigInteger nonce = BigInteger.ZERO;
        BigInteger gasPrice = BigInteger.ONE;
        BigInteger gasLimit = BigInteger.TEN;
        String to = "0x0add5355";
        BigInteger value = BigInteger.valueOf(Long.MAX_VALUE);
        Integer chainId = 1;
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (byte)chainId.byteValue(), (Credentials)SampleKeys.CREDENTIALS);
        String hexMessage = Numeric.toHexString((byte[])signedMessage);
        RawTransaction result = TransactionDecoder.decode((String)hexMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)nonce, (Object)result.getNonce());
        Assert.assertEquals((Object)gasPrice, (Object)result.getGasPrice());
        Assert.assertEquals((Object)gasLimit, (Object)result.getGasLimit());
        Assert.assertEquals((Object)to, (Object)result.getTo());
        Assert.assertEquals((Object)value, (Object)result.getValue());
        Assert.assertEquals((Object)"", (Object)result.getData());
        Assert.assertTrue((boolean)(result instanceof SignedRawTransaction));
        SignedRawTransaction signedResult = (SignedRawTransaction)result;
        Assert.assertEquals((Object)"0xef678007d18427e6022059dbc264f27507cd1ffc", (Object)signedResult.getFrom());
        signedResult.verify("0xef678007d18427e6022059dbc264f27507cd1ffc");
        Assert.assertEquals((Object)chainId, (Object)signedResult.getChainId());
    }

    @Test
    public void testRSize31() throws Exception {
        String hexTransaction = "0xf883370183419ce09433c98f20dd73d7bb1d533c4aa3371f2b30c6ebde80a45093dc7d00000000000000000000000000000000000000000000000000000000000000351c9fb90996c836fb34b782ee3d6efa9e2c79a75b277c014e353b51b23b00524d2da07435ebebca627a51a863bf590aff911c4746ab8386a0477c8221bb89671a5d58";
        RawTransaction result = TransactionDecoder.decode((String)hexTransaction);
        SignedRawTransaction signedResult = (SignedRawTransaction)result;
        Assert.assertEquals((Object)"0x1b609b03e2e9b0275a61fa5c69a8f32550285536", (Object)signedResult.getFrom());
    }
}

