/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.SampleKeys;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.rlp.RlpString;
import org.web3j.utils.Numeric;

public class TransactionEncoderTest {
    @Test
    public void testSignMessage() {
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)TransactionEncoderTest.createEtherTransaction(), (Credentials)SampleKeys.CREDENTIALS);
        String hexMessage = Numeric.toHexString((byte[])signedMessage);
        Assert.assertThat((Object)hexMessage, (Matcher)CoreMatchers.is((Object)"0xf85580010a840add5355887fffffffffffffff801ca046360b50498ddf5566551ce1ce69c46c565f1f478bb0ee680caf31fbc08ab727a01b2f1432de16d110407d544f519fc91b84c8e16d3b6ec899592d486a94974cd0"));
    }

    @Test
    public void testEtherTransactionAsRlpValues() {
        List rlpStrings = TransactionEncoder.asRlpValues((RawTransaction)TransactionEncoderTest.createEtherTransaction(), (Sign.SignatureData)new Sign.SignatureData(0, new byte[32], new byte[32]));
        Assert.assertThat((Object)rlpStrings.size(), (Matcher)CoreMatchers.is((Object)9));
        Assert.assertThat(rlpStrings.get(3), (Matcher)IsEqual.equalTo((Object)RlpString.create((BigInteger)new BigInteger("add5355", 16))));
    }

    @Test
    public void testContractAsRlpValues() {
        List rlpStrings = TransactionEncoder.asRlpValues((RawTransaction)TransactionEncoderTest.createContractTransaction(), null);
        Assert.assertThat((Object)rlpStrings.size(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat(rlpStrings.get(3), (Matcher)CoreMatchers.is((Object)RlpString.create((String)"")));
    }

    @Test
    public void testEip155Encode() {
        Assert.assertThat((Object)TransactionEncoder.encode((RawTransaction)TransactionEncoderTest.createEip155RawTransaction(), (byte)1), (Matcher)CoreMatchers.is((Object)Numeric.hexStringToByteArray((String)"0xec098504a817c800825208943535353535353535353535353535353535353535880de0b6b3a764000080018080")));
    }

    @Test
    public void testEip155Transaction() {
        Credentials credentials = Credentials.create((String)"0x4646464646464646464646464646464646464646464646464646464646464646");
        Assert.assertThat((Object)TransactionEncoder.signMessage((RawTransaction)TransactionEncoderTest.createEip155RawTransaction(), (byte)1, (Credentials)credentials), (Matcher)CoreMatchers.is((Object)Numeric.hexStringToByteArray((String)"0xf86c098504a817c800825208943535353535353535353535353535353535353535880de0b6b3a76400008025a028ef61340bd939bc2195fe537567866003e1a15d3c71ff63e1590620aa636276a067cbe9d8997f761aecb703304b3800ccf555c9f3dc64214b297fb1966a3b6d83")));
    }

    private static RawTransaction createEtherTransaction() {
        return RawTransaction.createEtherTransaction((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN, (String)"0xadd5355", (BigInteger)BigInteger.valueOf(Long.MAX_VALUE));
    }

    static RawTransaction createContractTransaction() {
        return RawTransaction.createContractTransaction((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN, (BigInteger)BigInteger.valueOf(Long.MAX_VALUE), (String)"01234566789");
    }

    private static RawTransaction createEip155RawTransaction() {
        return RawTransaction.createEtherTransaction((BigInteger)BigInteger.valueOf(9L), (BigInteger)BigInteger.valueOf(20000000000L), (BigInteger)BigInteger.valueOf(21000L), (String)"0x3535353535353535353535353535353535353535", (BigInteger)BigInteger.valueOf(1000000000000000000L));
    }
}

