/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.web3j.crypto.Bip39Wallet;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.crypto.SampleKeys;
import org.web3j.crypto.WalletUtils;
import org.web3j.utils.Numeric;

public class WalletUtilsTest {
    private File tempDir;

    @Before
    public void setUp() throws Exception {
        this.tempDir = WalletUtilsTest.createTempDir();
    }

    @After
    public void tearDown() throws Exception {
        for (File file : this.tempDir.listFiles()) {
            file.delete();
        }
        this.tempDir.delete();
    }

    @Test
    public void testGenerateBip39Wallets() throws Exception {
        Bip39Wallet wallet = WalletUtils.generateBip39Wallet((String)"Insecure Pa55w0rd", (File)this.tempDir);
        byte[] seed = MnemonicUtils.generateSeed((String)wallet.getMnemonic(), (String)"Insecure Pa55w0rd");
        Credentials credentials = Credentials.create((ECKeyPair)ECKeyPair.create((byte[])Hash.sha256((byte[])seed)));
        Assert.assertEquals((Object)credentials, (Object)WalletUtils.loadBip39Credentials((String)"Insecure Pa55w0rd", (String)wallet.getMnemonic()));
    }

    @Test
    public void testGenerateFullNewWalletFile() throws Exception {
        String fileName = WalletUtils.generateFullNewWalletFile((String)"Insecure Pa55w0rd", (File)this.tempDir);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGenerateNewWalletFile() throws Exception {
        String fileName = WalletUtils.generateNewWalletFile((String)"Insecure Pa55w0rd", (File)this.tempDir);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGenerateLightNewWalletFile() throws Exception {
        String fileName = WalletUtils.generateLightNewWalletFile((String)"Insecure Pa55w0rd", (File)this.tempDir);
        this.testGeneratedNewWalletFile(fileName);
    }

    private void testGeneratedNewWalletFile(String fileName) throws Exception {
        WalletUtils.loadCredentials((String)"Insecure Pa55w0rd", (File)new File(this.tempDir, fileName));
    }

    @Test
    public void testGenerateFullWalletFile() throws Exception {
        String fileName = WalletUtils.generateWalletFile((String)"Insecure Pa55w0rd", (ECKeyPair)SampleKeys.KEY_PAIR, (File)this.tempDir, (boolean)true);
        this.testGenerateWalletFile(fileName);
    }

    @Test
    public void testGenerateLightWalletFile() throws Exception {
        String fileName = WalletUtils.generateWalletFile((String)"Insecure Pa55w0rd", (ECKeyPair)SampleKeys.KEY_PAIR, (File)this.tempDir, (boolean)false);
        this.testGenerateWalletFile(fileName);
    }

    private void testGenerateWalletFile(String fileName) throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"Insecure Pa55w0rd", (File)new File(this.tempDir, fileName));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Test
    public void testLoadCredentialsFromFile() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"Insecure Pa55w0rd", (File)new File(WalletUtilsTest.class.getResource("/keyfiles/UTC--2016-11-03T05-55-06.340672473Z--ef678007d18427e6022059dbc264f27507cd1ffc").getFile()));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Test
    public void testLoadCredentialsFromString() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"Insecure Pa55w0rd", (String)WalletUtilsTest.class.getResource("/keyfiles/UTC--2016-11-03T05-55-06.340672473Z--ef678007d18427e6022059dbc264f27507cd1ffc").getFile());
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Ignore
    @Test
    public void testLoadCredentialsMyEtherWallet() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"Insecure Pa55w0rd", (File)new File(WalletUtilsTest.class.getResource("/keyfiles/UTC--2016-11-03T07-47-45.988Z--4f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818").getFile()));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)Credentials.create((String)"6ca4203d715e693279d6cd9742ad2fb7a3f6f4abe27a64da92e0a70ae5d859c9")));
    }

    @Test
    public void testGetDefaultKeyDirectory() {
        Assert.assertTrue((boolean)WalletUtils.getDefaultKeyDirectory((String)"Mac OS X").endsWith(String.format("%sLibrary%sEthereum", File.separator, File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getDefaultKeyDirectory((String)"Windows").endsWith(String.format("%sEthereum", File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getDefaultKeyDirectory((String)"Linux").endsWith(String.format("%s.ethereum", File.separator)));
    }

    @Test
    public void testGetTestnetKeyDirectory() {
        Assert.assertTrue((boolean)WalletUtils.getMainnetKeyDirectory().endsWith(String.format("%skeystore", File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getTestnetKeyDirectory().endsWith(String.format("%stestnet%skeystore", File.separator, File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getRinkebyKeyDirectory().endsWith(String.format("%srinkeby%skeystore", File.separator, File.separator)));
    }

    private static File createTempDir() throws Exception {
        return Files.createTempDirectory(WalletUtilsTest.class.getSimpleName() + "-testkeys", new FileAttribute[0]).toFile();
    }

    @Test
    public void testIsValidPrivateKey() {
        Assert.assertTrue((boolean)WalletUtils.isValidPrivateKey((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6"));
        Assert.assertTrue((boolean)WalletUtils.isValidPrivateKey((String)Numeric.prependHexPrefix((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6")));
        Assert.assertFalse((boolean)WalletUtils.isValidPrivateKey((String)""));
        Assert.assertFalse((boolean)WalletUtils.isValidPrivateKey((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6a"));
        Assert.assertFalse((boolean)WalletUtils.isValidPrivateKey((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6".substring(1)));
    }

    @Test
    public void testIsValidAddress() {
        Assert.assertTrue((boolean)WalletUtils.isValidAddress((String)"0xef678007d18427e6022059dbc264f27507cd1ffc"));
        Assert.assertTrue((boolean)WalletUtils.isValidAddress((String)SampleKeys.ADDRESS_NO_PREFIX));
        Assert.assertFalse((boolean)WalletUtils.isValidAddress((String)""));
        Assert.assertFalse((boolean)WalletUtils.isValidAddress((String)"0xef678007d18427e6022059dbc264f27507cd1ffca"));
        Assert.assertFalse((boolean)WalletUtils.isValidAddress((String)"0xef678007d18427e6022059dbc264f27507cd1ffc".substring(1)));
    }
}

