/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.geth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.geth.Geth;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;

public class JsonRpc2_0GethTest {
    private WebSocketClient webSocketClient = (WebSocketClient)Mockito.mock(WebSocketClient.class);
    private WebSocketService webSocketService = new WebSocketService(this.webSocketClient, true);
    private Geth geth = Geth.build((Web3jService)this.webSocketService);
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private WebSocketListener listener;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.webSocketClient.connectBlocking()).thenReturn((Object)true);
        ((WebSocketClient)Mockito.doAnswer(invocation -> {
            this.listener = (WebSocketListener)invocation.getArgumentAt(0, WebSocketListener.class);
            return null;
        }).when((Object)this.webSocketClient)).setListener((WebSocketListener)Matchers.any());
        ((WebSocketClient)Mockito.doAnswer(invocation -> {
            String message = (String)invocation.getArgumentAt(0, String.class);
            int requestId = this.getRequestId(message);
            this.sendSubscriptionConfirmation(requestId);
            return null;
        }).when((Object)this.webSocketClient)).send(Matchers.anyString());
        this.webSocketService.connect();
    }

    @Test
    public void testPendingTransactionsNotifications() {
        this.geth.newPendingTransactionsNotifications();
        ((WebSocketClient)Mockito.verify((Object)this.webSocketClient)).send(Matchers.matches((String)"\\{\"jsonrpc\":\"2.0\",\"method\":\"eth_subscribe\",\"params\":\\[\"newPendingTransactions\"],\"id\":[0-9]{1,}}"));
    }

    @Test
    public void testSyncingStatusNotifications() {
        this.geth.syncingStatusNotifications();
        ((WebSocketClient)Mockito.verify((Object)this.webSocketClient)).send(Matchers.matches((String)"\\{\"jsonrpc\":\"2.0\",\"method\":\"eth_subscribe\",\"params\":\\[\"syncing\"],\"id\":[0-9]{1,}}"));
    }

    private int getRequestId(String message) throws IOException {
        JsonNode messageJson = this.objectMapper.readTree(message);
        return messageJson.get("id").asInt();
    }

    private void sendSubscriptionConfirmation(int requestId) throws IOException {
        this.listener.onMessage(String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"result\":\"0xcd0c3e8af590364c09d0fa6a1210faf5\"}", requestId));
    }
}

