/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.geth;

import org.junit.Test;
import org.web3j.protocol.RequestTester;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.geth.Geth;
import org.web3j.protocol.http.HttpService;

public class RequestTest
extends RequestTester {
    private Geth web3j;

    protected void initWeb3Client(HttpService httpService) {
        this.web3j = Geth.build((Web3jService)httpService);
    }

    @Test
    public void testPersonalImportRawKey() throws Exception {
        String rawKey = "a08165236279178312660610114131826512483935470542850824183737259708197206310322";
        String password = "hunter2";
        this.web3j.personalImportRawKey(rawKey, password).send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"personal_importRawKey\",\"params\":[\"a08165236279178312660610114131826512483935470542850824183737259708197206310322\",\"hunter2\"],\"id\":1}");
    }

    @Test
    public void testPersonalLockAccount() throws Exception {
        String accountId = "0x407d73d8a49eeb85d32cf465507dd71d507100c1";
        this.web3j.personalLockAccount(accountId).send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"personal_lockAccount\",\"params\":[\"0x407d73d8a49eeb85d32cf465507dd71d507100c1\"],\"id\":1}");
    }

    @Test
    public void testPersonalSign() throws Exception {
        this.web3j.personalSign("0xdeadbeaf", "0x9b2055d370f73ec7d8a03e965129118dc8f5bf83", "hunter2").send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"personal_sign\",\"params\":[\"0xdeadbeaf\",\"0x9b2055d370f73ec7d8a03e965129118dc8f5bf83\",\"hunter2\"],\"id\":1}");
    }

    @Test
    public void testPersonalEcRecover() throws Exception {
        this.web3j.personalEcRecover("0xdeadbeaf", "0xa3f20717a250c2b0b729b7e5becbff67fdaef7e0699da4de7ca5895b02a170a12d887fd3b17bfdce3481f10bea41f45ba9f709d39ce8325427b57afcfc994cee1b").send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"personal_ecRecover\",\"params\":[\"0xdeadbeaf\",\"0xa3f20717a250c2b0b729b7e5becbff67fdaef7e0699da4de7ca5895b02a170a12d887fd3b17bfdce3481f10bea41f45ba9f709d39ce8325427b57afcfc994cee1b\"],\"id\":1}");
    }

    @Test
    public void testMinerStart() throws Exception {
        this.web3j.minerStart(4).send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"miner_start\",\"params\":[4],\"id\":1}");
    }

    @Test
    public void testMinerStop() throws Exception {
        this.web3j.minerStop().send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"miner_stop\",\"params\":[],\"id\":1}");
    }
}

