package com.platon.common;

import com.platon.rlp.RLPCodec;
import org.apache.commons.lang3.StringUtils;
import org.web3j.tx.ChainId;
import org.web3j.utils.Numeric;

import java.util.Arrays;

/**
 * User address of privacy token
 *
 * @author AgentRJ
 * Created on: 2020-12-14 10:00
 */
public class PrivacyAddress {

    private byte[] view_pk;

    private byte[] spend_pk;

    public PrivacyAddress(String address) {
        PrivacyAddress privacyAddress = RLPCodec.decode(Numeric.hexStringToByteArray(address),
                PrivacyAddress.class, ChainId.NONE);
        this.view_pk = privacyAddress.getView_pk();
        this.spend_pk = privacyAddress.getSpend_pk();
    }

    public PrivacyAddress(byte[] view_pk, byte[] spend_pk) {
        if (null == view_pk || view_pk.length == 0) {
            throw new RuntimeException("Invalid view_pk");
        }
        if (null == spend_pk || spend_pk.length == 0) {
            throw new RuntimeException("Invalid spend_pk");
        }
        this.view_pk = view_pk;
        this.spend_pk = spend_pk;
    }

    public PrivacyAddress(String view_pk, String spend_pk) {
        if (StringUtils.isEmpty(view_pk)) {
            throw new RuntimeException("Invalid view_pk");
        }
        if (StringUtils.isEmpty(spend_pk)) {
            throw new RuntimeException("Invalid spend_pk");
        }
        this.view_pk = Numeric.hexStringToByteArray(view_pk);
        this.spend_pk = Numeric.hexStringToByteArray(spend_pk);
    }

    public String getAddress() {
        return Numeric.toHexString(RLPCodec.encode(this));
    }

    @Override
    public String toString() {
        return "PrivacyAddress{" +
                "view_pk=" + Arrays.toString(view_pk) +
                ", spend_pk=" + Arrays.toString(spend_pk) +
                '}';
    }

    public byte[] getView_pk() {
        return view_pk;
    }

    public void setView_pk(byte[] view_pk) {
        this.view_pk = view_pk;
    }

    public byte[] getSpend_pk() {
        return spend_pk;
    }

    public void setSpend_pk(byte[] spend_pk) {
        this.spend_pk = spend_pk;
    }
}
