package com.platon.common;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * @author AgentRJ
 * Created on: 2020-12-07 18:09
 */
public class UTXOPool {

    private List<UTXO> pool;

    /**
     * the privacy address of user.
     */
    private String address;

    /**
     * the address of contract.
     */
    private String contract;

    /**
     * the public key of spender
     */
    private byte[] spendPk;

    /**
     * the public key of viewer
     */
    private byte[] viewPk;

    public void add(UTXO utxo) {
        if (null == pool) {
            pool = new ArrayList<>();
        }
        this.pool.add(utxo);
    }

    public boolean exists(String noteHash) {
        if (pool == null) {
            return false;
        }
        for (int i = 0; i < pool.size(); i++) {
            if (pool.get(i).getNoteHash().equalsIgnoreCase(noteHash)) {
                return true;
            }
        }
        return false;
    }

    public UTXO getByNoteHash(String noteHash) {
        if (pool == null) {
            return null;
        }
        for (int i = 0; i < pool.size(); i++) {
            if (pool.get(i).getNoteHash().equalsIgnoreCase(noteHash)) {
                return pool.get(i);
            }
        }
        return null;
    }

    public boolean isCorrect(String noteHash, BigInteger quantity) {
        if (pool == null) {
            return false;
        }
        for (int i = 0; i < pool.size(); i++) {
            if (pool.get(i).getNoteHash().equalsIgnoreCase(noteHash) && pool.get(i).getQuality().compareTo(quantity) == 0) {
                return true;
            }
        }
        return false;
    }

    public void remove(String noteHash) {
        if (pool == null) {
            return;
        }
        int removeIndex = -1;
        for (int i = 0; i < pool.size(); i++) {
            if (pool.get(i).getNoteHash().equalsIgnoreCase(noteHash)) {
                removeIndex = i;
                break;
            }
        }
        if (removeIndex != -1) {
            pool.remove(removeIndex);
        }
    }

    public List<UTXO> getPool() {
        return pool;
    }

    public void setPool(List<UTXO> pool) {
        this.pool = pool;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContract() {
        return contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public byte[] getSpendPk() {
        return spendPk;
    }

    public void setSpendPk(byte[] spendPk) {
        this.spendPk = spendPk;
    }

    public byte[] getViewPk() {
        return viewPk;
    }

    public void setViewPk(byte[] viewPk) {
        this.viewPk = viewPk;
    }
}
