package com.platon.common.methods.request;

import com.platon.common.constants.ConfidentialTXType;
import com.platon.rlp.datatypes.WasmAddress;

import java.util.LinkedList;
import java.util.List;

/**
 * Burn transaction request message parameters.
 *
 * @author AgentRJ
 * Created on: 2020-12-03 11:28
 */
public class BurnRequest {

    /**
     * Burn transaction type, burn = 3
     */
    public int tx_type;

    /**
     * List of notes waiting to be destroyed
     */
    public List<ConfidentialInputNote> input;

    public byte[] authorized_address;

    public BurnRequest() {
        this.input = new LinkedList<>();
        this.tx_type = ConfidentialTXType.BURN;
    }

    public int getTx_type() {
        return tx_type;
    }

    public void setTx_type(int tx_type) {
        this.tx_type = tx_type;
    }

    public List<ConfidentialInputNote> getInput() {
        return input;
    }

    public void setInput(List<ConfidentialInputNote> input) {
        this.input = input;
    }

    public byte[] getAuthorized_address() {
        return authorized_address;
    }

    public void setAuthorized_address(byte[] authorized_address) {
        this.authorized_address = authorized_address;
    }

    public void setAuthorized_address(String authorized_address) {
        this.authorized_address = new WasmAddress(authorized_address).getValue();
    }

}
