package com.platon.common.methods.request;

/**
 * Data structure of proof message for private transaction.
 *
 * @author AgentRJ
 * Created on: 2020-12-03 11:10
 */
public class ConfidentialDataProof {

    /**
     * ConfidentialData(Signed RLP encoded data).
     */
    private byte[] data;

    /**
     * Data signed using ECC algorithm.
     */
    private byte[] signature;

    public ConfidentialDataProof() {

    }

    public ConfidentialDataProof(byte[] data, byte[] signature) {
        this.data = data;
        this.signature = signature;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getSignature() {
        return signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }
}
