package com.platon.common.methods.request;

import com.platon.common.PrivacyAddress;

import java.math.BigInteger;

/**
 * @author AgentRJ
 * Created on: 2020-12-03 11:03
 */
public class ConfidentialOutputNote {

    public BigInteger quatity;
    public byte[] view_pk;
    public byte[] spend_pk;

    public ConfidentialOutputNote() {
    }

    public ConfidentialOutputNote(PrivacyAddress privacyAddress, BigInteger quality) {
        this.quatity = quality;
        this.view_pk = privacyAddress.getView_pk();
        this.spend_pk = privacyAddress.getSpend_pk();
    }

    public ConfidentialOutputNote(BigInteger quatity, byte[] view_pk, byte[] spend_pk) {
        this.quatity = quatity;
        this.view_pk = view_pk;
        this.spend_pk = spend_pk;
    }

    public BigInteger getQuatity() {
        return quatity;
    }

    public void setQuatity(BigInteger quatity) {
        this.quatity = quatity;
    }

    public byte[] getView_pk() {
        return view_pk;
    }

    public void setView_pk(byte[] view_pk) {
        this.view_pk = view_pk;
    }

    public byte[] getSpend_pk() {
        return spend_pk;
    }

    public void setSpend_pk(byte[] spend_pk) {
        this.spend_pk = spend_pk;
    }
}
