package com.platon.common.methods.request;

import com.platon.common.constants.ConfidentialTXType;
import com.platon.rlp.datatypes.WasmAddress;

import java.util.LinkedList;
import java.util.List;

/**
 * @author AgentRJ
 * Created on: 2020-12-03 11:27
 */
public class MintRequest {

    public int tx_type;
    public List<ConfidentialOutputNote> output;
    public byte[] authorized_address;

    public MintRequest() {
        this.output = new LinkedList<>();
        this.tx_type = ConfidentialTXType.MINT;
    }

    public int getTx_type() {
        return tx_type;
    }

    public void setTx_type(int tx_type) {
        this.tx_type = tx_type;
    }

    public List<ConfidentialOutputNote> getOutput() {
        return output;
    }

    public void setOutput(List<ConfidentialOutputNote> output) {
        this.output = output;
    }

    public byte[] getAuthorized_address() {
        return authorized_address;
    }

    public void setAuthorized_address(byte[] authorized_address) {
        this.authorized_address = authorized_address;
    }

    public void setAuthorized_address(String authorized_address) {
        this.authorized_address = new WasmAddress(authorized_address).getValue();
    }
}
