/*
 * Decompiled with CFR 0.152.
 */
package com.platon.common;

import com.platon.rlp.RLPCodec;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.web3j.utils.Numeric;

public class PrivacyAddress {
    private byte[] view_pk;
    private byte[] spend_pk;

    public PrivacyAddress(String address) {
        PrivacyAddress privacyAddress = (PrivacyAddress)RLPCodec.decode((byte[])Numeric.hexStringToByteArray((String)address), PrivacyAddress.class, (long)-1L);
        this.view_pk = privacyAddress.getView_pk();
        this.spend_pk = privacyAddress.getSpend_pk();
    }

    public PrivacyAddress(byte[] view_pk, byte[] spend_pk) {
        if (null == view_pk || view_pk.length == 0) {
            throw new RuntimeException("Invalid view_pk");
        }
        if (null == spend_pk || spend_pk.length == 0) {
            throw new RuntimeException("Invalid spend_pk");
        }
        this.view_pk = view_pk;
        this.spend_pk = spend_pk;
    }

    public PrivacyAddress(String view_pk, String spend_pk) {
        if (StringUtils.isEmpty((CharSequence)view_pk)) {
            throw new RuntimeException("Invalid view_pk");
        }
        if (StringUtils.isEmpty((CharSequence)spend_pk)) {
            throw new RuntimeException("Invalid spend_pk");
        }
        this.view_pk = Numeric.hexStringToByteArray((String)view_pk);
        this.spend_pk = Numeric.hexStringToByteArray((String)spend_pk);
    }

    public String getAddress() {
        return Numeric.toHexString((byte[])RLPCodec.encode((Object)this));
    }

    public String toString() {
        return "PrivacyAddress{view_pk=" + Arrays.toString(this.view_pk) + ", spend_pk=" + Arrays.toString(this.spend_pk) + '}';
    }

    public byte[] getView_pk() {
        return this.view_pk;
    }

    public void setView_pk(byte[] view_pk) {
        this.view_pk = view_pk;
    }

    public byte[] getSpend_pk() {
        return this.spend_pk;
    }

    public void setSpend_pk(byte[] spend_pk) {
        this.spend_pk = spend_pk;
    }
}

