/*
 * Decompiled with CFR 0.152.
 */
package com.platon.common;

import com.platon.common.UTXO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class UTXOPool {
    private List<UTXO> pool;
    private String address;
    private String contract;
    private byte[] spendPk;
    private byte[] viewPk;

    public void add(UTXO utxo) {
        if (null == this.pool) {
            this.pool = new ArrayList<UTXO>();
        }
        this.pool.add(utxo);
    }

    public boolean exists(String noteHash) {
        if (this.pool == null) {
            return false;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            if (!this.pool.get(i).getNoteHash().equalsIgnoreCase(noteHash)) continue;
            return true;
        }
        return false;
    }

    public UTXO getByNoteHash(String noteHash) {
        if (this.pool == null) {
            return null;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            if (!this.pool.get(i).getNoteHash().equalsIgnoreCase(noteHash)) continue;
            return this.pool.get(i);
        }
        return null;
    }

    public boolean isCorrect(String noteHash, BigInteger quantity) {
        if (this.pool == null) {
            return false;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            if (!this.pool.get(i).getNoteHash().equalsIgnoreCase(noteHash) || this.pool.get(i).getQuality().compareTo(quantity) != 0) continue;
            return true;
        }
        return false;
    }

    public void remove(String noteHash) {
        if (this.pool == null) {
            return;
        }
        int removeIndex = -1;
        for (int i = 0; i < this.pool.size(); ++i) {
            if (!this.pool.get(i).getNoteHash().equalsIgnoreCase(noteHash)) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex != -1) {
            this.pool.remove(removeIndex);
        }
    }

    public List<UTXO> getPool() {
        return this.pool;
    }

    public void setPool(List<UTXO> pool) {
        this.pool = pool;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public byte[] getSpendPk() {
        return this.spendPk;
    }

    public void setSpendPk(byte[] spendPk) {
        this.spendPk = spendPk;
    }

    public byte[] getViewPk() {
        return this.viewPk;
    }

    public void setViewPk(byte[] viewPk) {
        this.viewPk = viewPk;
    }
}

