/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.ConfidentialTxJNA;
import com.platon.rlp.RLPCodec;
import com.platon.rlp.datatypes.Uint32;
import com.platon.rlp.datatypes.Uint64;
import com.platon.rlp.datatypes.WasmAddress;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

public class Confidential {
    public static long name = 0x1000000L;
    public static long major = 65536L;
    public static long minor = 256L;
    public static long currentVersion = name + major + minor;
    public static long minorUpdateVersion = name + major + 512L;
    public static long majorUpdateVersion = name + 131072L + minor;
    public byte[] viewSk;
    public byte[] viewPk;
    public byte[] spendSk;
    public byte[] spendPk;
    public long chainId;

    public Keypair CreateKeypair() {
        byte[] bytes = ConfidentialTxJNA.create_keypair(new byte[10], 0);
        return (Keypair)RLPCodec.decode((byte[])bytes, Keypair.class, (long)this.chainId);
    }

    public Confidential(long chainId) {
        this.chainId = chainId;
        Keypair viewKeyPair = this.CreateKeypair();
        this.viewSk = viewKeyPair.privateKey;
        this.viewPk = viewKeyPair.publicKey;
        Keypair spendKeyPair = this.CreateKeypair();
        this.spendSk = spendKeyPair.privateKey;
        this.spendPk = spendKeyPair.publicKey;
    }

    static {
        System.out.println(minorUpdateVersion);
        System.out.println(majorUpdateVersion);
    }

    public static class MetaDataInfo {
        public String hash;
        public String data;

        public MetaDataInfo(String hash, String data) {
            this.hash = hash;
            this.data = data;
        }
    }

    public static class OutputInfo
    extends ConfidentialInput {
        public String owner;
        public String hash;
        public boolean hasCreateNoteEvent;

        public OutputInfo(Confidential one, BigInteger quatity, byte[] blinding, byte[] ephemeral_pk, byte[] sign_pk, String owner, String hash, boolean hasCreateNoteEvent) {
            super(one, quatity, blinding, ephemeral_pk, sign_pk);
            this.owner = owner;
            this.hash = hash;
            this.hasCreateNoteEvent = hasCreateNoteEvent;
        }
    }

    public static class ConfidentialUTXO {
        public byte txType;
        public List<ConfidentialInputNote> inputs = new LinkedList<ConfidentialInputNote>();
        public List<ConfidentialOutputNote> outputs = new LinkedList<ConfidentialOutputNote>();
        public Uint64 publicValue;
        public WasmAddress authorizedAddress;
    }

    public static class ConfidentialOutputNote {
        public byte[] nodeId;
        public byte[] ephemeralPk;
        public byte[] signPk;
        public byte[] token;
        public byte[] cipherValue;
    }

    public static class ConfidentialInputNote {
        public byte[] nodeId;
        public byte[] ephemeralPk;
        public byte[] signPk;
        public byte[] token;
    }

    public static class PlainValue {
        public Uint64 quatity;
        public byte[] blinding;
    }

    public static class EncryptedOwner {
        public byte[] ephemeralPk;
        public byte[] signPk;
    }

    public static class ConfidentialProof {
        public byte[] data;
        public byte[] signature;
    }

    public static class ConfidentialData {
        public Uint32 version;
        public byte[] confidentialTx;
        public byte[] extraData;
    }

    public static class BurnExtra {
        public byte[] oldBurnHash;
    }

    public static class MintExtra {
        public byte[] oldMintHash;
        public List<byte[]> metaData = new LinkedList<byte[]>();
    }

    public static class TransferExtra {
        public WasmAddress publicOwner;
        public byte[] depositSignature;
        public List<byte[]> metaData = new LinkedList<byte[]>();
    }

    public static class Withdraw {
        public int tx_type = 5;
        public List<ConfidentialInput> input = new LinkedList<ConfidentialInput>();
        public List<ConfidentialOutput> output = new LinkedList<ConfidentialOutput>();
        public byte[] authorized_address;

        public int getTx_type() {
            return this.tx_type;
        }

        public void setTx_type(int tx_type) {
            this.tx_type = tx_type;
        }

        public List<ConfidentialInput> getInput() {
            return this.input;
        }

        public void setInput(List<ConfidentialInput> input) {
            this.input = input;
        }

        public List<ConfidentialOutput> getOutput() {
            return this.output;
        }

        public void setOutput(List<ConfidentialOutput> output) {
            this.output = output;
        }

        public byte[] getAuthorized_address() {
            return this.authorized_address;
        }

        public void setAuthorized_address(byte[] authorized_address) {
            this.authorized_address = authorized_address;
        }
    }

    public static class Deposit {
        public int tx_type = 4;
        public List<ConfidentialInput> input = new LinkedList<ConfidentialInput>();
        public List<ConfidentialOutput> output = new LinkedList<ConfidentialOutput>();
        public byte[] authorized_address;

        public int getTx_type() {
            return this.tx_type;
        }

        public void setTx_type(int tx_type) {
            this.tx_type = tx_type;
        }

        public List<ConfidentialInput> getInput() {
            return this.input;
        }

        public void setInput(List<ConfidentialInput> input) {
            this.input = input;
        }

        public List<ConfidentialOutput> getOutput() {
            return this.output;
        }

        public void setOutput(List<ConfidentialOutput> output) {
            this.output = output;
        }

        public byte[] getAuthorized_address() {
            return this.authorized_address;
        }

        public void setAuthorized_address(byte[] authorized_address) {
            this.authorized_address = authorized_address;
        }
    }

    public static class Burn {
        public int tx_type = 3;
        public List<ConfidentialInput> input = new LinkedList<ConfidentialInput>();
        public byte[] authorized_address;

        public int getTx_type() {
            return this.tx_type;
        }

        public void setTx_type(int tx_type) {
            this.tx_type = tx_type;
        }

        public List<ConfidentialInput> getInput() {
            return this.input;
        }

        public void setInput(List<ConfidentialInput> input) {
            this.input = input;
        }

        public byte[] getAuthorized_address() {
            return this.authorized_address;
        }

        public void setAuthorized_address(byte[] authorized_address) {
            this.authorized_address = authorized_address;
        }
    }

    public static class Mint {
        public int tx_type = 2;
        public List<ConfidentialOutput> output = new LinkedList<ConfidentialOutput>();
        public byte[] authorized_address;

        public int getTx_type() {
            return this.tx_type;
        }

        public void setTx_type(int tx_type) {
            this.tx_type = tx_type;
        }

        public List<ConfidentialOutput> getOutput() {
            return this.output;
        }

        public void setOutput(List<ConfidentialOutput> output) {
            this.output = output;
        }

        public byte[] getAuthorized_address() {
            return this.authorized_address;
        }

        public void setAuthorized_address(byte[] authorized_address) {
            this.authorized_address = authorized_address;
        }
    }

    public static class Transfer {
        public int tx_type = 1;
        public List<ConfidentialInput> input = new LinkedList<ConfidentialInput>();
        public List<ConfidentialOutput> output = new LinkedList<ConfidentialOutput>();
        public byte[] authorized_address;

        public int getTx_type() {
            return this.tx_type;
        }

        public void setTx_type(int tx_type) {
            this.tx_type = tx_type;
        }

        public List<ConfidentialInput> getInput() {
            return this.input;
        }

        public void setInput(List<ConfidentialInput> input) {
            this.input = input;
        }

        public List<ConfidentialOutput> getOutput() {
            return this.output;
        }

        public void setOutput(List<ConfidentialInput> output) {
            this.input = output;
        }

        public byte[] getAuthorized_address() {
            return this.authorized_address;
        }

        public void setAuthorized_address(byte[] authorized_address) {
            this.authorized_address = authorized_address;
        }
    }

    public static class ConfidentialTXType {
        public static final int TRANSFER = 1;
        public static final int MINT = 2;
        public static final int BURN = 3;
        public static final int DEPOSIT = 4;
        public static final int WITHDRAW = 5;
        public static final int APPROVE = 6;
    }

    public static class ConfidentialOutput {
        public BigInteger quatity;
        public byte[] view_pk;
        public byte[] spend_pk;

        public ConfidentialOutput(Confidential one, BigInteger quatity) {
            this.quatity = quatity;
            this.view_pk = one.viewPk;
            this.spend_pk = one.spendPk;
        }

        public BigInteger getQuatity() {
            return this.quatity;
        }

        public void setQuatity(BigInteger quatity) {
            this.quatity = quatity;
        }

        public byte[] getView_pk() {
            return this.view_pk;
        }

        public void setView_pk(byte[] view_pk) {
            this.view_pk = view_pk;
        }

        public byte[] getSpend_pk() {
            return this.spend_pk;
        }

        public void setSpend_pk(byte[] spend_pk) {
            this.spend_pk = spend_pk;
        }
    }

    public static class ConfidentialInput {
        public byte[] ephemeral_pk;
        public byte[] sign_pk;
        public BigInteger quatity;
        public byte[] blinding;
        public byte[] view_sk;
        public byte[] spend_sk;

        public ConfidentialInput() {
        }

        public ConfidentialInput(Confidential one, BigInteger quatity, byte[] blinding, byte[] ephemeral_pk, byte[] sign_pk) {
            this.ephemeral_pk = ephemeral_pk;
            this.sign_pk = sign_pk;
            this.quatity = quatity;
            this.blinding = blinding;
            this.view_sk = one.viewSk;
            this.spend_sk = one.spendSk;
        }

        public byte[] getEphemeral_pk() {
            return this.ephemeral_pk;
        }

        public void setEphemeral_pk(byte[] ephemeral_pk) {
            this.ephemeral_pk = ephemeral_pk;
        }

        public byte[] getSign_pk() {
            return this.sign_pk;
        }

        public void setSign_pk(byte[] sign_pk) {
            this.sign_pk = sign_pk;
        }

        public BigInteger getQuatity() {
            return this.quatity;
        }

        public void setQuatity(BigInteger quatity) {
            this.quatity = quatity;
        }

        public byte[] getBlinding() {
            return this.blinding;
        }

        public void setBlinding(byte[] blinding) {
            this.blinding = blinding;
        }

        public byte[] getView_sk() {
            return this.view_sk;
        }

        public void setView_sk(byte[] view_sk) {
            this.view_sk = view_sk;
        }

        public byte[] getSpend_sk() {
            return this.spend_sk;
        }

        public void setSpend_sk(byte[] spend_sk) {
            this.spend_sk = spend_sk;
        }
    }

    public static class Keypair {
        public byte[] privateKey;
        public byte[] publicKey;
    }
}

