/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.common.PrivacyAddress;
import com.platon.crypto.Keypair;
import java.util.Objects;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;

public class CredentialsWrapper {
    public Keypair viewKeypair;
    public Keypair spendKeypair;
    private Credentials credentials;
    private PrivacyAddress privacyAddress;

    private CredentialsWrapper(Keypair viewKeypair, Keypair spendKeypair, Credentials credentials) {
        this.viewKeypair = viewKeypair;
        this.spendKeypair = spendKeypair;
        this.credentials = credentials;
        this.privacyAddress = new PrivacyAddress(viewKeypair.getPublicKey(), spendKeypair.getPublicKey());
    }

    public String getPrivacyAddress() {
        return this.privacyAddress.getAddress();
    }

    public String getAddress(long chainId) {
        return this.credentials.getAddress(chainId);
    }

    public PrivacyAddress getPrivacy() {
        return this.privacyAddress;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Keypair getViewKeypair() {
        return this.viewKeypair;
    }

    public Keypair getSpendKeypair() {
        return this.spendKeypair;
    }

    public static CredentialsWrapper generate(long chainId) {
        Credentials credentials = null;
        try {
            credentials = Credentials.create((ECKeyPair)Keys.createEcKeyPair());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Keypair viewKeypair = Keypair.createKeypair(chainId);
        Keypair spendKeypair = Keypair.createKeypair(chainId);
        return new CredentialsWrapper(viewKeypair, spendKeypair, credentials);
    }

    public static CredentialsWrapper randomCreate(ECKeyPair ecKeyPair, long chainId) {
        Credentials credentials = Credentials.create((ECKeyPair)ecKeyPair);
        Keypair viewKeypair = Keypair.createKeypair(chainId);
        Keypair spendKeypair = Keypair.createKeypair(chainId);
        return new CredentialsWrapper(viewKeypair, spendKeypair, credentials);
    }

    public static CredentialsWrapper create(String viewingKey, String spendingKey, String privateKey, long chainId) {
        Keypair viewingKeypair = Keypair.createKeypair(Numeric.hexStringToByteArray((String)viewingKey), chainId);
        Keypair spendingKeypair = Keypair.createKeypair(Numeric.hexStringToByteArray((String)spendingKey), chainId);
        Credentials credentials = Credentials.create((String)privateKey);
        return new CredentialsWrapper(viewingKeypair, spendingKeypair, credentials);
    }

    public static CredentialsWrapper load(String viewingSk, String viewingPk, String spendingSk, String spendingPk, String privateKey) {
        Keypair viewingKeypair = new Keypair(Numeric.hexStringToByteArray((String)viewingSk), Numeric.hexStringToByteArray((String)viewingPk));
        Keypair spendingKeypair = new Keypair(Numeric.hexStringToByteArray((String)spendingSk), Numeric.hexStringToByteArray((String)spendingPk));
        Credentials credentials = Credentials.create((String)privateKey);
        return new CredentialsWrapper(viewingKeypair, spendingKeypair, credentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialsWrapper that = (CredentialsWrapper)o;
        return Objects.equals(this.viewKeypair, that.viewKeypair) && Objects.equals(this.spendKeypair, that.spendKeypair) && Objects.equals(this.credentials, that.credentials);
    }

    public int hashCode() {
        return Objects.hash(this.viewKeypair, this.spendKeypair, this.credentials);
    }
}

