/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.google.common.primitives.Bytes;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.crypto.Hash;

public class SharedSecret {
    private static String CURVE_NAME = "secp256k1";
    private static X9ECParameters params = SECNamedCurves.getByName((String)CURVE_NAME);
    private static ECDomainParameters CURVE = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
    private byte[] privateKey;

    public SharedSecret(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public static SharedSecret generate(BigInteger sk, BigInteger pk) {
        ECPrivateKeyParameters privKeyP = new ECPrivateKeyParameters(new BigInteger(sk.toByteArray()), CURVE);
        byte[] prefix = Hex.decode((String)"04");
        byte[] point = Bytes.concat((byte[][])new byte[][]{prefix, pk.toByteArray()});
        ECPublicKeyParameters pubKeyP = new ECPublicKeyParameters(CURVE.getCurve().decodePoint(point), CURVE);
        ECDHBasicAgreement agreement = new ECDHBasicAgreement();
        agreement.init((CipherParameters)privKeyP);
        System.out.println(agreement.calculateAgreement((CipherParameters)pubKeyP).toString());
        return new SharedSecret(Hash.sha3((byte[])agreement.calculateAgreement((CipherParameters)pubKeyP).toByteArray()));
    }

    public byte[] encryption(byte[] data) throws InvalidCipherTextException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PaddedBufferedBlockCipher encryptCipher = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine());
        encryptCipher.init(true, (CipherParameters)new KeyParameter(this.privateKey));
        byte[] out = new byte[1024];
        int len = encryptCipher.processBytes(data, 0, data.length, out, 0);
        len += encryptCipher.doFinal(out, len);
        return Arrays.copyOfRange(out, 0, len);
    }

    public byte[] decrypt(byte[] data) throws InvalidCipherTextException {
        PaddedBufferedBlockCipher decryptCipher = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine());
        decryptCipher.init(false, (CipherParameters)new KeyParameter(this.privateKey));
        byte[] plaintext = new byte[1024];
        int len = decryptCipher.processBytes(data, 0, data.length, plaintext, 0);
        len += decryptCipher.doFinal(plaintext, len);
        return Arrays.copyOfRange(plaintext, 0, len);
    }
}

