package com.platon.crypto;

import com.ochafik.lang.jnaerator.runtime.LibraryExtractor;
import com.ochafik.lang.jnaerator.runtime.MangledFunctionMapper;
import com.platon.crypto.ByteBuffer.ByValue;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

import java.nio.ByteBuffer;

/**
 * JNA Wrapper for library <b>com.platon.privacy.confidential</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public interface ConfidentialLibrary extends Library {
    public static final String JNA_LIBRARY_NAME = LibraryExtractor.getLibraryPath("confidentialtx", true, ConfidentialLibrary.class);
//    public static final NativeLibrary JNA_NATIVE_LIB = NativeLibrary.getInstance(ConfidentialLibrary.JNA_LIBRARY_NAME, MangledFunctionMapper.DEFAULT_OPTIONS);
    public static final ConfidentialLibrary INSTANCE = (ConfidentialLibrary)Native.loadLibrary(ConfidentialLibrary.JNA_LIBRARY_NAME, ConfidentialLibrary.class, MangledFunctionMapper.DEFAULT_OPTIONS);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int _STDINT_H = (int)1;
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT8_MIN = (int)(-128);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT16_MIN = (int)(-32767 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT32_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INT64_MIN = (long)(-9223372036854775807L - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT8_MAX = (int)(127);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT16_MAX = (int)(32767);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT32_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INT64_MAX = (long)(9223372036854775807L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int UINT8_MAX = (int)(255);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int UINT16_MAX = (int)(65535);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT32_MAX = (long)(4294967295L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT64_MAX = (long)(-1L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_LEAST8_MIN = (int)(-128);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_LEAST16_MIN = (int)(-32767 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_LEAST32_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INT_LEAST64_MIN = (long)(-9223372036854775807L - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_LEAST8_MAX = (int)(127);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_LEAST16_MAX = (int)(32767);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_LEAST32_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INT_LEAST64_MAX = (long)(9223372036854775807L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int UINT_LEAST8_MAX = (int)(255);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int UINT_LEAST16_MAX = (int)(65535);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT_LEAST32_MAX = (long)(4294967295L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT_LEAST64_MAX = (long)(-1L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_FAST8_MIN = (int)(-128);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_FAST16_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_FAST32_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INT_FAST64_MIN = (long)(-9223372036854775807L - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_FAST8_MAX = (int)(127);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_FAST16_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INT_FAST32_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INT_FAST64_MAX = (long)(9223372036854775807L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int UINT_FAST8_MAX = (int)(255);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT_FAST16_MAX = (long)(4294967295L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT_FAST32_MAX = (long)(4294967295L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINT_FAST64_MAX = (long)(-1L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INTPTR_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int INTPTR_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINTPTR_MAX = (long)(4294967295L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INTMAX_MIN = (long)(-9223372036854775807L - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long INTMAX_MAX = (long)(9223372036854775807L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long UINTMAX_MAX = (long)(-1L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int PTRDIFF_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int PTRDIFF_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int SIG_ATOMIC_MIN = (int)(-2147483647 - 1);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int SIG_ATOMIC_MAX = (int)(2147483647);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long SIZE_MAX = (long)(4294967295L);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final int WINT_MIN = (int)(0);
    /** <i>native declaration : /usr/include/stdint.h</i> */
    public static final long WINT_MAX = (long)(4294967295L);
    /**
     * Create a confidential tx.<br>
     *  In:     tx_json:    a pointer to tx json string.<br>
     *  In:     tx_len:     the size of tx json string.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of tx. Otherwise return null.<br>
     * Original signature : <code>ResultBuffer create_confidential_tx(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:315</i><br>
     * @deprecated use the safer methods {@link #create_confidential_tx(byte[], int, com.platon.crypto.ExternError)} and {@link #create_confidential_tx(Pointer, int, com.platon.crypto.ExternError)} instead
     */
    @Deprecated
    ByValue create_confidential_tx(Pointer tx_json, int tx_len, ExternError error);
    /**
     * Create a confidential tx.<br>
     *  In:     tx_json:    a pointer to tx json string.<br>
     *  In:     tx_len:     the size of tx json string.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of tx. Otherwise return null.<br>
     * Original signature : <code>ResultBuffer create_confidential_tx(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:315</i>
     */
    ByValue create_confidential_tx(byte tx_json[], int tx_len, ExternError error);
    /**
     * Create a confidential tx.<br>
     *  In:     tx_json:    a pointer to tx rlp stream.<br>
     *  In:     tx_len:     the size of tx rlp stream.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of tx. Otherwise return null.<br>
     * Original signature : <code>ResultBuffer create_confidential_tx_by_rlp(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : confidentialtx.h:40</i><br>
     * @deprecated use the safer methods {@link #create_confidential_tx_by_rlp(byte[], int, com.platon.crypto.ExternError)} and {@link #create_confidential_tx_by_rlp(Pointer, int, com.platon.crypto.ExternError)} instead
     */
    @Deprecated
    ByValue create_confidential_tx_by_rlp(Pointer tx_json, int tx_len, ExternError error);
    /**
     * Create a confidential tx.<br>
     *  In:     tx_json:    a pointer to tx rlp stream.<br>
     *  In:     tx_len:     the size of tx rlp stream.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of tx. Otherwise return null.<br>
     * Original signature : <code>ResultBuffer create_confidential_tx_by_rlp(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : confidentialtx.h:40</i>
     */
    ByValue create_confidential_tx_by_rlp(byte tx_json[], int tx_len, ExternError error);
    /**
     * Verify the confidential tx.<br>
     *  In:     tx_data:    a pointer to tx string generated by 'create_confidential_tx'.<br>
     *  In:     tx_len:     the size of tx string.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of tx log. Otherwise return null.<br>
     * Original signature : <code>ResultBuffer confidential_tx_verify(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:326</i><br>
     * @deprecated use the safer methods {@link #confidential_tx_verify(byte[], int, com.platon.crypto.ExternError)} and {@link #confidential_tx_verify(Pointer, int, com.platon.crypto.ExternError)} instead
     */
    @Deprecated
    ByValue confidential_tx_verify(Pointer tx_data, int tx_len, ExternError error);
    /**
     * Verify the confidential tx.<br>
     *  In:     tx_data:    a pointer to tx string generated by 'create_confidential_tx'.<br>
     *  In:     tx_len:     the size of tx string.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of tx log. Otherwise return null.<br>
     * Original signature : <code>ResultBuffer confidential_tx_verify(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:326</i>
     */
    ByValue confidential_tx_verify(byte tx_data[], int tx_len, ExternError error);
    /**
     * Create a key pair for view key and spend key.<br>
     *  Note: if sk_data is null or sk_len is 0, 'create_keypair' will output a random key pair.<br>
     * <br>
     *  In:     sk_data:    a pointer to sk string of "user's input".<br>
     *  In:     sk_len:     the size of sk string.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of key pair json string. Otherwise return null.<br>
     * <br>
     *  The output key pair format is rlp encoding.<br>
     * Original signature : <code>ResultBuffer create_keypair(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:342</i><br>
     * @deprecated use the safer methods {@link #create_keypair(byte[], int, com.platon.crypto.ExternError)} and {@link #create_keypair(Pointer, int, com.platon.crypto.ExternError)} instead
     */
    @Deprecated
    ByValue create_keypair(Pointer sk_data, int sk_len, ExternError error);
    /**
     * Create a key pair for view key and spend key.<br>
     *  Note: if sk_data is null or sk_len is 0, 'create_keypair' will output a random key pair.<br>
     * <br>
     *  In:     sk_data:    a pointer to sk string of "user's input".<br>
     *  In:     sk_len:     the size of sk string.<br>
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of key pair json string. Otherwise return null.<br>
     * <br>
     *  The output key pair format is rlp encoding.<br>
     * Original signature : <code>ResultBuffer create_keypair(const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:342</i>
     */
    ByValue create_keypair(byte sk_data[], int sk_len, ExternError error);
    /**
     * Is the owner of note.<br>
     *  In:     ephemeral_pk_data:    a pointer to ephemeral_pk.<br>
     *  In:     ephemeral_pk_len:     the size of ephemeral_pk.<br>
     *  In:     sign_pk_data:         a pointer to sign_pk.<br>
     *  In:     sign_pk_len:          the size of sign_pk.<br>
     *  In:     view_sk_data:         a pointer to view_sk.<br>
     *  In:     view_sk_len:          the size of view_sk.<br>
     *  Out:    error:                output a ExternError. 'code' 0 represents success, it is the correct owner. All other values represent failure.<br>
     *                                If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * Original signature : <code>void is_note_owner(const uint8_t*, int32_t, const uint8_t*, int32_t, const uint8_t*, int32_t, const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:357</i><br>
     * @deprecated use the safer methods {@link #is_note_owner(byte[], int, byte[], int, byte[], int, byte[], int, com.platon.crypto.ExternError)} and {@link #is_note_owner(Pointer, int, Pointer, int, Pointer, int, Pointer, int, com.platon.crypto.ExternError)} instead
     */
    @Deprecated
    void is_note_owner(Pointer ephemeral_pk_data, int ephemeral_pk_len, Pointer sign_pk_data, int sign_pk_len, Pointer spend_pk_data, int spend_pk_len, Pointer view_sk_data, int view_sk_len, ExternError error);
    /**
     * Is the owner of note.<br>
     *  In:     ephemeral_pk_data:    a pointer to ephemeral_pk.<br>
     *  In:     ephemeral_pk_len:     the size of ephemeral_pk.<br>
     *  In:     sign_pk_data:         a pointer to sign_pk.<br>
     *  In:     sign_pk_len:          the size of sign_pk.<br>
     *  In:     view_sk_data:         a pointer to view_sk.<br>
     *  In:     view_sk_len:          the size of view_sk.<br>
     *  Out:    error:                output a ExternError. 'code' 0 represents success, it is the correct owner. All other values represent failure.<br>
     *                                If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * Original signature : <code>void is_note_owner(const uint8_t*, int32_t, const uint8_t*, int32_t, const uint8_t*, int32_t, const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:357</i>
     */
    void is_note_owner(byte ephemeral_pk_data[], int ephemeral_pk_len, byte sign_pk_data[], int sign_pk_len, byte spend_pk_data[], int spend_pk_len, byte view_sk_data[], int view_sk_len, ExternError error);
    /**
     * Decrypt the quatity and blinding.<br>
     *  In:     cipher_data:    a pointer to ephemeral_pk.<br>
     *  In:     cipher_len:     the size of ephemeral_pk.<br>
     *  In:     view_sk_data:   a pointer to view_sk.<br>
     *  In:     view_sk_len:    the size of view_sk.<br>
     *  Out:    error:          output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                          If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of quatity and blinding. Otherwise return null.<br>
     *  Using the rlp encoding of quatity and blinding.<br>
     * Original signature : <code>ResultBuffer decrypt_note(const uint8_t*, int32_t, const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:376</i><br>
     * @deprecated use the safer methods {@link #decrypt_note(byte[], int, byte[], int, com.platon.crypto.ExternError)} and {@link #decrypt_note(Pointer, int, Pointer, int, com.platon.crypto.ExternError)} instead
     */
    @Deprecated
    ByValue decrypt_note(Pointer cipher_data, int cipher_len, Pointer view_sk_data, int view_sk_len, ExternError error);
    /**
     * Decrypt the quatity and blinding.<br>
     *  In:     cipher_data:    a pointer to ephemeral_pk.<br>
     *  In:     cipher_len:     the size of ephemeral_pk.<br>
     *  In:     view_sk_data:   a pointer to view_sk.<br>
     *  In:     view_sk_len:    the size of view_sk.<br>
     *  Out:    error:          output a ExternError. 'code' 0 represents success, all other values represent failure.<br>
     *                          If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.<br>
     * <br>
     *  Returns: if success, return pointer and len of quatity and blinding. Otherwise return null.<br>
     *  Using the rlp encoding of quatity and blinding.<br>
     * Original signature : <code>ResultBuffer decrypt_note(const uint8_t*, int32_t, const uint8_t*, int32_t, ConfidentialTxError*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:376</i>
     */
    ByValue decrypt_note(byte cipher_data[], int cipher_len, byte view_sk_data[], int view_sk_len, ExternError error);
    /**
     * NOTE: MUST Release the result buffer manually<br>
     * Original signature : <code>void confidential_tx_destroy_bytebuffer(ResultBuffer)</code><br>
     * <i>native declaration : /usr/include/stdint.h:381</i>
     */
    void confidential_tx_destroy_bytebuffer(ByValue buffer);
    /**
     * NOTE: MUST Release the error message manually<br>
     * Original signature : <code>void confidential_tx_destroy_string(char*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:384</i><br>
     * @deprecated use the safer methods {@link #confidential_tx_destroy_string(ByteBuffer)} and {@link #confidential_tx_destroy_string(Pointer)} instead
     */
    @Deprecated
    void confidential_tx_destroy_string(Pointer ptr);
    /**
     * NOTE: MUST Release the error message manually<br>
     * Original signature : <code>void confidential_tx_destroy_string(char*)</code><br>
     * <i>native declaration : /usr/include/stdint.h:384</i>
     */
    void confidential_tx_destroy_string(ByteBuffer ptr);
}
