package com.platon.crypto;

import com.platon.rlp.RLPCodec;
import org.web3j.tx.ChainId;

/**
 * @author AgentRJ
 * Created on: 2020-12-03 11:32
 */
public class Keypair {

    public byte[] privateKey;
    public byte[] publicKey;

    public Keypair() {}

    public Keypair(byte[] privateKey, byte[] publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public byte[] getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public static Keypair createKeypair() {
        byte[] bytes = ConfidentialTxJNA.create_keypair(new byte[10], 0);
        return RLPCodec.decode(bytes, Keypair.class, ChainId.NONE);
    }

    public static Keypair createKeypair(long chainId) {
        byte[] bytes = ConfidentialTxJNA.create_keypair(new byte[10], 0);
        return RLPCodec.decode(bytes, Keypair.class, chainId);
    }

    public static Keypair createKeypair(byte[] key, long chainId) {
        byte[] bytes = ConfidentialTxJNA.create_keypair(key, key.length);
        return RLPCodec.decode(bytes, Keypair.class, chainId);
    }

    public static Keypair createKeypair(byte[] key) {
        byte[] bytes = ConfidentialTxJNA.create_keypair(key, key.length);
        return RLPCodec.decode(bytes, Keypair.class, ChainId.NONE);
    }
}
