package com.platon.crypto;

public class ConfidentialTxJNA {
    /** Create a confidential tx.
     *
     *  In:     tx_json:    a pointer to tx json string.
     *  In:     tx_len:     the size of tx json string.
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.
     *
     *  Returns: if success, return pointer and len of tx. Otherwise return null.
     */
    public static byte[] create_confidential_tx(byte[] tx_json, int tx_len) {
        com.platon.crypto.ExternError error = new com.platon.crypto.ExternError();
        com.platon.crypto.ByteBuffer.ByValue value = com.platon.crypto.ConfidentialLibrary.INSTANCE.create_confidential_tx(tx_json, tx_len, error);
        if(0 != error.code){
            try {
                throw new Exception(error.message.getString(0));
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_string(error.message);
            }
        }
        byte[] resultBytes = value.data.getByteArray(0, (int)value.len);
        com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_bytebuffer(value);
        return resultBytes;
    }
    /** Create a confidential tx.
     *
     *  In:     tx_json:    a pointer to tx rlp stream.
     *  In:     tx_len:     the size of tx rlp stream.
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.
     *
     *  Returns: if success, return pointer and len of tx. Otherwise return null.
     */
    public static byte[] create_confidential_tx_by_rlp(byte[] data, int data_len) {
        com.platon.crypto.ExternError error = new com.platon.crypto.ExternError();
        com.platon.crypto.ByteBuffer.ByValue value = com.platon.crypto.ConfidentialLibrary.INSTANCE.create_confidential_tx_by_rlp(data, data_len, error);
        if(0 != error.code){
            try {
                throw new Exception(error.message.getString(0));
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_string(error.message);
            }
        }
        byte[] resultBytes = value.data.getByteArray(0, (int)value.len);
        com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_bytebuffer(value);
        return resultBytes;
    }

    /** Verify the confidential tx.
     *
     *  In:     tx_data:    a pointer to tx string generated by 'create_confidential_tx'.
     *  In:     tx_len:     the size of tx string.
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.
     *
     *  Returns: if success, return pointer and len of tx log. Otherwise return null.
     */
    public static byte[] confidential_tx_verify(byte tx_data[], int tx_len){
        com.platon.crypto.ExternError error = new com.platon.crypto.ExternError();
        com.platon.crypto.ByteBuffer.ByValue value = com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_verify(tx_data, tx_len, error);
        if(0 != error.code){
            try {
                throw new Exception(error.message.getString(0));
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_string(error.message);
            }
        }
        byte[] resultBytes = value.data.getByteArray(0, (int)value.len);
        com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_bytebuffer(value);
        return resultBytes;
    }

    /** Create a key pair for view key and spend key.
     *
     *  Note: if sk_data is null or sk_len is 0, 'create_keypair' will output a random key pair.
     *
     *  In:     sk_data:    a pointer to sk string of "user's input".
     *  In:     sk_len:     the size of sk string.
     *  Out:    error:      output a ExternError. 'code' 0 represents success, all other values represent failure.
     *                      If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.
     *
     *  Returns: if success, return pointer and len of key pair json string. Otherwise return null.
     *
     *  The output key pair format is rlp encoding.
     *
     */
    public static byte[] create_keypair(byte sk_data[], int sk_len){
        com.platon.crypto.ExternError error = new com.platon.crypto.ExternError();
        com.platon.crypto.ByteBuffer.ByValue value = com.platon.crypto.ConfidentialLibrary.INSTANCE.create_keypair(sk_data, sk_len, error);
        if(0 != error.code){
            try {
                throw new Exception(error.message.getString(0));
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_string(error.message);
            }
        }
        byte[] resultBytes = value.data.getByteArray(0, (int)value.len);
        com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_bytebuffer(value);
        return resultBytes;
    }

    /** Is the owner of note.
     *
     *  In:     ephemeral_pk_data:    a pointer to ephemeral_pk.
     *  In:     ephemeral_pk_len:     the size of ephemeral_pk.
     *  In:     sign_pk_data:         a pointer to sign_pk.
     *  In:     sign_pk_len:          the size of sign_pk.
     *  In:     view_sk_data:         a pointer to view_sk.
     *  In:     view_sk_len:          the size of view_sk.
     *  Out:    error:                output a ExternError. 'code' 0 represents success, it is the correct owner. All other values represent failure.
     *                                If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.
     */
    public static boolean is_note_owner(byte ephemeral_pk_data[], int ephemeral_pk_len, byte sign_pk_data[], int sign_pk_len, byte spend_pk_data[], int spend_pk_len, byte view_sk_data[], int view_sk_len){
        com.platon.crypto.ExternError error = new com.platon.crypto.ExternError();
        com.platon.crypto.ConfidentialLibrary.INSTANCE.is_note_owner(ephemeral_pk_data, ephemeral_pk_len, sign_pk_data, sign_pk_len, spend_pk_data, spend_pk_len, view_sk_data, view_sk_len, error);
        if( 0 == error.code) return true;
        if(0 != error.code){
            try {
                //throw new Exception(error.message.getString(0));
            } catch (Exception e) {
                //e.printStackTrace();
            } finally {
                //com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_string(error.message);
            }
        }
        return false;
    }

    /** Decrypt the quatity and blinding.
     *
     *  In:     cipher_data:    a pointer to ephemeral_pk.
     *  In:     cipher_len:     the size of ephemeral_pk.
     *  In:     view_sk_data:   a pointer to view_sk.
     *  In:     view_sk_len:    the size of view_sk.
     *  Out:    error:          output a ExternError. 'code' 0 represents success, all other values represent failure.
     *                          If the `code` field is nonzero, there should always be a message, and if it's zero, the message will always be null.
     *
     *  Returns: if success, return pointer and len of quatity and blinding. Otherwise return null.
     *  Using the rlp encoding of quatity and blinding.
     *
     */
    public static byte[] decrypt_note(byte cipher_data[], int cipher_len, byte view_sk_data[], int view_sk_len){
        com.platon.crypto.ExternError error = new com.platon.crypto.ExternError();
        com.platon.crypto.ByteBuffer.ByValue value = com.platon.crypto.ConfidentialLibrary.INSTANCE.decrypt_note(cipher_data, cipher_len, view_sk_data, view_sk_len, error);
        if(0 != error.code){
            try {
                throw new Exception(error.message.getString(0));
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_string(error.message);
            }
        }
        byte[] resultBytes = value.data.getByteArray(0, (int)value.len);
        com.platon.crypto.ConfidentialLibrary.INSTANCE.confidential_tx_destroy_bytebuffer(value);
        return resultBytes;
    }

}
