package com.platon.storage.db;

import java.io.UnsupportedEncodingException;

/**
 * DB涉及到的Key管理
 *
 * @author AgentRJ
 * Created on: 2020-12-07 19:12
 */
public class DBKey {

    /**
     * The key prefix of the stored note data.
     */
    private static final String db_prefix_note = "note_";

    /**
     * The key prefix of the stored mint data.
     */
    private static final String db_prefix_mint = "mint_";

    /**
     * The key prefix of the stored burn data.
     */
    private static final String db_prefix_burn = "burn_";

    /**
     * The key prefix of the stored meta data.
     */
    private static final String db_prefix_meta = "meta_";

    public static byte[] getNoteKey(String address, String contract) {
        StringBuffer sb = new StringBuffer();
        sb.append(db_prefix_note);
        sb.append(address).append("_");
        sb.append(contract);
        try {
            return sb.toString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Get the key of note failed", e);
        }
    }

    public static byte[] getMintKey(String address, String contract, String mintHash) {
        StringBuffer sb = new StringBuffer();
        sb.append(db_prefix_mint);
        sb.append(address).append("_");
        sb.append(contract).append("_").append(mintHash);
        try {
            return sb.toString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Get the key of mint failed", e);
        }
    }

    public static byte[] getLatestMintKey(String address, String contract) {
        StringBuffer sb = new StringBuffer();
        sb.append(db_prefix_mint);
        sb.append(address).append("_");
        sb.append(contract);
        try {
            return sb.toString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Get the latest key of mint failed", e);
        }
    }

    public static byte[] getBurnKey(String address, String contract, String burnHash) {
        StringBuffer sb = new StringBuffer();
        sb.append(db_prefix_burn);
        sb.append(address).append("_");
        sb.append(contract).append("_").append(burnHash);
        try {
            return sb.toString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Get the key of burn failed", e);
        }
    }

    public static byte[] getLatestBurnKey(String address, String contract) {
        StringBuffer sb = new StringBuffer();
        sb.append(db_prefix_burn);
        sb.append(address).append("_");
        sb.append(contract);
        try {
            return sb.toString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Get the latest key of note failed", e);
        }
    }

    public static byte[] getMetadataKey(String address, String contract, String noteHash) {
        StringBuffer sb = new StringBuffer();
        sb.append(db_prefix_meta);
        sb.append(address).append("_");
        sb.append(contract).append("_").append(noteHash);
        try {
            return sb.toString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Get the key of metadata failed", e);
        }
    }
}
