package com.platon.sync;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Event Synchronization Task Manager.
 *
 * 1.Start and execute a synchronous task for event analysis;
 *
 * @author AgentRJ
 * Created on: 2020-12-04 16:21
 */
public class EventSyncManager {

    private static final Logger logger = LoggerFactory.getLogger("sync");

    private Web3j web3j;
    private ThreadFactory threadFactory;
    private ExecutorService executor;
    private long chainId;

    private final AtomicBoolean started = new AtomicBoolean(false);

    public EventSyncManager(Web3j web3j, long chainId) {
        this.web3j = web3j;
        this.chainId = chainId;
        threadFactory = Executors.defaultThreadFactory();
        executor = Executors.newFixedThreadPool(10, threadFactory);
        started.set(true);
    }

    public List<PrivacyEventMessage> execute(List<String> contracts, long startBn, long endBn) {
        WorkerThread callable = new WorkerThread(web3j, contracts, startBn, endBn, chainId);
        Future<List<PrivacyEventMessage>> future = executor.submit(callable);
        try {
            List<PrivacyEventMessage> list = future.get();
            //List<PrivacyEventMessage> list = callable.call();
            return list;
        } catch (Exception e) {
            throw new RuntimeException("process event message failed, error: " + e.getMessage());
        }
    }

    public long blockNumber() {
        try {
            return web3j.platonBlockNumber().send().getBlockNumber().longValue();
        } catch (IOException e) {
            logger.error("获取链上块高失败", e);
        }
        return 0l;
    }


    public void stop() {
        //executorPool.shutdown();
        executor.shutdown();
        started.set(false);
    }

    public boolean isStarted() {
        return started.get();
    }

    @Deprecated
    private void startWorker(List<String> contracts, long startBn, long endBn) {
        logger.debug("Add new work for sync, contracts: {}, startBn: {}, endBn: {}",
                JSON.toJSONString(contracts), startBn, endBn);
        WorkerThread callable = new WorkerThread(web3j, contracts, startBn, endBn, chainId);
        Future<List<PrivacyEventMessage>> future = executor.submit(callable);
        try {
            List<PrivacyEventMessage> list = future.get();
            //eventQueue.addEventMessages(list);
        } catch (Exception e) {
            logger.error("start worker throw exception", e);
        }
    }
}
