package com.platon.sync;

import com.platon.common.events.response.*;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * All event records corresponding to the contract address on each block.
 *
 * @author AgentRJ
 * Created on: 2020-12-04 17:06
 */
public class PrivacyEventMessage {

    private String contract;
    private BigInteger blockNumber;
    private String blockHash;

    private List<DestroyNoteResponse> destroyNoteEventResponses;
    private List<CreateNoteResponse> createNoteEventResponses;
    private List<MintResponse> mintEventResponses;
    private List<BurnResponse> burnEventResponses;
    private List<CreateDetailNoteResponse> createNoteDetailEventResponses;
    private List<MetaDataResponse> metaDataResponses;

    public PrivacyEventMessage() {
        destroyNoteEventResponses = new ArrayList<>();
        createNoteEventResponses = new ArrayList<>();
        mintEventResponses = new ArrayList<>();
        burnEventResponses = new ArrayList<>();
        createNoteDetailEventResponses = new ArrayList<>();
        metaDataResponses = new ArrayList<>();
    }

    public BigInteger getBlockNumber() {
        return blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getBlockHash() {
        return blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public List<DestroyNoteResponse> getDestroyNoteEventResponses() {
        return destroyNoteEventResponses;
    }

    public void setDestroyNoteEventResponses(List<DestroyNoteResponse> destroyNoteEventResponses) {
        this.destroyNoteEventResponses = destroyNoteEventResponses;
    }

    public List<CreateNoteResponse> getCreateNoteEventResponses() {
        return createNoteEventResponses;
    }

    public void setCreateNoteEventResponses(List<CreateNoteResponse> createNoteEventResponses) {
        this.createNoteEventResponses = createNoteEventResponses;
    }

    public List<MintResponse> getMintEventResponses() {
        return mintEventResponses;
    }

    public void setMintEventResponses(List<MintResponse> mintEventResponses) {
        this.mintEventResponses = mintEventResponses;
    }

    public List<BurnResponse> getBurnEventResponses() {
        return burnEventResponses;
    }

    public void setBurnEventResponses(List<BurnResponse> burnEventResponses) {
        this.burnEventResponses = burnEventResponses;
    }

    public List<CreateDetailNoteResponse> getCreateNoteDetailEventResponses() {
        return createNoteDetailEventResponses;
    }

    public void setCreateNoteDetailEventResponses(List<CreateDetailNoteResponse> createNoteDetailEventResponses) {
        this.createNoteDetailEventResponses = createNoteDetailEventResponses;
    }

    public List<MetaDataResponse> getMetaDataResponses() {
        return metaDataResponses;
    }

    public void setMetaDataResponses(List<MetaDataResponse> metaDataResponses) {
        this.metaDataResponses = metaDataResponses;
    }

    public String getContract() {
        return contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }
}
