/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.platon.TempFileProvider;
import com.platon.abi.solidity.datatypes.Address;
import com.platon.abi.solidity.datatypes.Bool;
import com.platon.abi.solidity.datatypes.DynamicArray;
import com.platon.abi.solidity.datatypes.DynamicBytes;
import com.platon.abi.solidity.datatypes.StaticArray;
import com.platon.abi.solidity.datatypes.Utf8String;
import com.platon.abi.solidity.datatypes.generated.Bytes32;
import com.platon.abi.solidity.datatypes.generated.Int256;
import com.platon.abi.solidity.datatypes.generated.StaticArray10;
import com.platon.abi.solidity.datatypes.generated.StaticArray2;
import com.platon.abi.solidity.datatypes.generated.StaticArray3;
import com.platon.abi.solidity.datatypes.generated.Uint256;
import com.platon.abi.solidity.datatypes.generated.Uint64;
import com.platon.codegen.GenerationReporter;
import com.platon.codegen.SolidityFunctionWrapper;
import com.platon.protocol.core.methods.response.AbiDefinition;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SolidityFunctionWrapperTest
extends TempFileProvider {
    private SolidityFunctionWrapper solidityFunctionWrapper;
    private GenerationReporter generationReporter;

    public void setUp() throws Exception {
        super.setUp();
        this.generationReporter = (GenerationReporter)Mockito.mock(GenerationReporter.class);
        this.solidityFunctionWrapper = new SolidityFunctionWrapper(true, this.generationReporter);
    }

    @Test
    public void testCreateValidParamName() {
        Assert.assertThat((Object)SolidityFunctionWrapper.createValidParamName((String)"param", (int)1), (Matcher)Is.is((Object)"param"));
        Assert.assertThat((Object)SolidityFunctionWrapper.createValidParamName((String)"", (int)1), (Matcher)Is.is((Object)"param1"));
    }

    @Test
    public void testBuildTypeName() {
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256"), (Matcher)Is.is((Object)ClassName.get(Uint256.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint64"), (Matcher)Is.is((Object)ClassName.get(Uint64.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"string"), (Matcher)Is.is((Object)ClassName.get(Utf8String.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[]"), (Matcher)Is.is((Object)ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{Uint256.class})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[] storage"), (Matcher)Is.is((Object)ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{Uint256.class})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[] memory"), (Matcher)Is.is((Object)ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{Uint256.class})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[10]"), (Matcher)Is.is((Object)ParameterizedTypeName.get(StaticArray10.class, (Type[])new Type[]{Uint256.class})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[33]"), (Matcher)Is.is((Object)ParameterizedTypeName.get(StaticArray.class, (Type[])new Type[]{Uint256.class})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[10][3]"), (Matcher)Is.is((Object)ParameterizedTypeName.get((ClassName)ClassName.get(StaticArray3.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get(StaticArray10.class, (Type[])new Type[]{Uint256.class})})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[2][]"), (Matcher)Is.is((Object)ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get(StaticArray2.class, (Type[])new Type[]{Uint256.class})})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[33][]"), (Matcher)Is.is((Object)ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get(StaticArray.class, (Type[])new Type[]{Uint256.class})})));
        Assert.assertThat((Object)SolidityFunctionWrapper.buildTypeName((String)"uint256[][]"), (Matcher)Is.is((Object)ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{Uint256.class})})));
    }

    @Test
    public void testGetNativeType() {
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(Address.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(String.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(Uint256.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(BigInteger.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(Int256.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(BigInteger.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(Utf8String.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(String.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(Bool.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(Boolean.class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(Bytes32.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(byte[].class)));
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(DynamicBytes.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(byte[].class)));
    }

    @Test
    public void testGetNativeTypeParameterized() {
        Assert.assertThat((Object)SolidityFunctionWrapper.getNativeType((ParameterizedTypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{TypeName.get(Address.class)})), (Matcher)IsEqual.equalTo((Object)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get(String.class)})));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetNativeTypeInvalid() {
        SolidityFunctionWrapper.getNativeType((TypeName)TypeName.get(BigInteger.class));
    }

    @Test
    public void testGetEventNativeType() {
        Assert.assertThat((Object)SolidityFunctionWrapper.getEventNativeType((TypeName)TypeName.get(Utf8String.class)), (Matcher)IsEqual.equalTo((Object)TypeName.get(byte[].class)));
    }

    @Test
    public void testGetEventNativeTypeParameterized() {
        Assert.assertThat((Object)SolidityFunctionWrapper.getEventNativeType((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{TypeName.get(Address.class)})), (Matcher)IsEqual.equalTo((Object)TypeName.get(byte[].class)));
    }

    @Test
    public void testBuildFunctionTransaction() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(false, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Collections.emptyList(), "type", false);
        MethodSpec methodSpec = this.solidityFunctionWrapper.buildFunction(functionDefinition);
        String expected = "public com.platon.protocol.core.RemoteCall<com.platon.protocol.core.methods.response.TransactionReceipt> functionName(java.math.BigInteger param) {\n  final com.platon.abi.solidity.datatypes.Function function = new com.platon.abi.solidity.datatypes.Function(\n      FUNC_FUNCTIONNAME, \n      java.util.Arrays.<com.platon.abi.solidity.datatypes.Type>asList(new com.platon.abi.solidity.datatypes.generated.Uint8(param)), \n      java.util.Collections.<com.platon.abi.solidity.TypeReference<?>>emptyList());\n  return executeRemoteCallTransaction(function);\n}\n";
        Assert.assertThat((Object)methodSpec.toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildingFunctionTransactionThatReturnsValueReportsWarning() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(false, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Arrays.asList(new AbiDefinition.NamedType("result", "uint8")), "type", false);
        this.solidityFunctionWrapper.buildFunction(functionDefinition);
        ((GenerationReporter)Mockito.verify((Object)this.generationReporter)).report("Definition of the function functionName returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value");
    }

    @Test
    public void testBuildPayableFunctionTransaction() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(false, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Collections.emptyList(), "type", true);
        MethodSpec methodSpec = this.solidityFunctionWrapper.buildFunction(functionDefinition);
        String expected = "public com.platon.protocol.core.RemoteCall<com.platon.protocol.core.methods.response.TransactionReceipt> functionName(java.math.BigInteger param, java.math.BigInteger vonValue) {\n  final com.platon.abi.solidity.datatypes.Function function = new com.platon.abi.solidity.datatypes.Function(\n      FUNC_FUNCTIONNAME, \n      java.util.Arrays.<com.platon.abi.solidity.datatypes.Type>asList(new com.platon.abi.solidity.datatypes.generated.Uint8(param)), \n      java.util.Collections.<com.platon.abi.solidity.TypeReference<?>>emptyList());\n  return executeRemoteCallTransaction(function, vonValue);\n}\n";
        Assert.assertThat((Object)methodSpec.toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildFunctionConstantSingleValueReturn() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(true, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Arrays.asList(new AbiDefinition.NamedType("result", "int8")), "type", false);
        MethodSpec methodSpec = this.solidityFunctionWrapper.buildFunction(functionDefinition);
        String expected = "public com.platon.protocol.core.RemoteCall<java.math.BigInteger> functionName(java.math.BigInteger param) {\n  final com.platon.abi.solidity.datatypes.Function function = new com.platon.abi.solidity.datatypes.Function(FUNC_FUNCTIONNAME, \n      java.util.Arrays.<com.platon.abi.solidity.datatypes.Type>asList(new com.platon.abi.solidity.datatypes.generated.Uint8(param)), \n      java.util.Arrays.<com.platon.abi.solidity.TypeReference<?>>asList(new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.generated.Int8>() {}));\n  return executeRemoteCallSingleValueReturn(function, java.math.BigInteger.class);\n}\n";
        Assert.assertThat((Object)methodSpec.toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildFunctionConstantSingleValueRawListReturn() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(true, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Arrays.asList(new AbiDefinition.NamedType("result", "address[]")), "type", false);
        MethodSpec methodSpec = this.solidityFunctionWrapper.buildFunction(functionDefinition);
        String expected = "public com.platon.protocol.core.RemoteCall<java.util.List> functionName(java.math.BigInteger param) {\n  final com.platon.abi.solidity.datatypes.Function function = new com.platon.abi.solidity.datatypes.Function(FUNC_FUNCTIONNAME, \n      java.util.Arrays.<com.platon.abi.solidity.datatypes.Type>asList(new com.platon.abi.solidity.datatypes.generated.Uint8(param)), \n      java.util.Arrays.<com.platon.abi.solidity.TypeReference<?>>asList(new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.DynamicArray<com.platon.abi.solidity.datatypes.Address>>() {}));\n  return new com.platon.protocol.core.RemoteCall<java.util.List>(\n      new java.util.concurrent.Callable<java.util.List>() {\n        @java.lang.Override\n        @java.lang.SuppressWarnings(\"unchecked\")\n        public java.util.List call() throws java.lang.Exception {\n          java.util.List<com.platon.abi.solidity.datatypes.Type> result = (java.util.List<com.platon.abi.solidity.datatypes.Type>) executeCallSingleValueReturn(function, java.util.List.class);\n          return convertToNative(result);\n        }\n      });\n}\n";
        Assert.assertThat((Object)methodSpec.toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildFunctionConstantInvalid() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(true, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Collections.emptyList(), "type", false);
        MethodSpec methodSpec = this.solidityFunctionWrapper.buildFunction(functionDefinition);
        String expected = "public void functionName(java.math.BigInteger param) {\n  throw new RuntimeException(\"cannot call constant function with void return type\");\n}\n";
        Assert.assertThat((Object)methodSpec.toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildFunctionConstantMultipleValueReturn() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(true, Arrays.asList(new AbiDefinition.NamedType("param1", "uint8"), new AbiDefinition.NamedType("param2", "uint32")), "functionName", Arrays.asList(new AbiDefinition.NamedType("result1", "int8"), new AbiDefinition.NamedType("result2", "int32")), "type", false);
        MethodSpec methodSpec = this.solidityFunctionWrapper.buildFunction(functionDefinition);
        String expected = "public com.platon.protocol.core.RemoteCall<com.platon.tuples.generated.Tuple2<java.math.BigInteger, java.math.BigInteger>> functionName(java.math.BigInteger param1, java.math.BigInteger param2) {\n  final com.platon.abi.solidity.datatypes.Function function = new com.platon.abi.solidity.datatypes.Function(FUNC_FUNCTIONNAME, \n      java.util.Arrays.<com.platon.abi.solidity.datatypes.Type>asList(new com.platon.abi.solidity.datatypes.generated.Uint8(param1), \n      new com.platon.abi.solidity.datatypes.generated.Uint32(param2)), \n      java.util.Arrays.<com.platon.abi.solidity.TypeReference<?>>asList(new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.generated.Int8>() {}, new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.generated.Int32>() {}));\n  return new com.platon.protocol.core.RemoteCall<com.platon.tuples.generated.Tuple2<java.math.BigInteger, java.math.BigInteger>>(\n      new java.util.concurrent.Callable<com.platon.tuples.generated.Tuple2<java.math.BigInteger, java.math.BigInteger>>() {\n        @java.lang.Override\n        public com.platon.tuples.generated.Tuple2<java.math.BigInteger, java.math.BigInteger> call() throws java.lang.Exception {\n          java.util.List<com.platon.abi.solidity.datatypes.Type> results = executeCallMultipleValueReturn(function);\n          return new com.platon.tuples.generated.Tuple2<java.math.BigInteger, java.math.BigInteger>(\n              (java.math.BigInteger) results.get(0).getValue(), \n              (java.math.BigInteger) results.get(1).getValue());\n        }\n      });\n}\n";
        Assert.assertThat((Object)methodSpec.toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildEventConstantMultipleValueReturn() throws Exception {
        AbiDefinition.NamedType id = new AbiDefinition.NamedType("id", "string", true);
        AbiDefinition.NamedType fromAddress = new AbiDefinition.NamedType("from", "address");
        AbiDefinition.NamedType toAddress = new AbiDefinition.NamedType("to", "address");
        AbiDefinition.NamedType value = new AbiDefinition.NamedType("value", "uint256");
        AbiDefinition.NamedType message = new AbiDefinition.NamedType("message", "string");
        fromAddress.setIndexed(true);
        toAddress.setIndexed(true);
        AbiDefinition functionDefinition = new AbiDefinition(false, Arrays.asList(id, fromAddress, toAddress, value, message), "Transfer", new ArrayList(), "event", false);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"testClass");
        builder.addMethods((Iterable)this.solidityFunctionWrapper.buildEventFunctions(functionDefinition, builder));
        String expected = "class testClass {\n  public static final com.platon.abi.solidity.datatypes.Event TRANSFER_EVENT = new com.platon.abi.solidity.datatypes.Event(\"Transfer\", \n      java.util.Arrays.<com.platon.abi.solidity.TypeReference<?>>asList(new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.Utf8String>(true) {}, new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.Address>(true) {}, new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.Address>(true) {}, new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.generated.Uint256>() {}, new com.platon.abi.solidity.TypeReference<com.platon.abi.solidity.datatypes.Utf8String>() {}));\n  ;\n\n  public java.util.List<TransferEventResponse> getTransferEvents(com.platon.protocol.core.methods.response.TransactionReceipt transactionReceipt) {\n    java.util.List<com.platon.tx.Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);\n    java.util.ArrayList<TransferEventResponse> responses = new java.util.ArrayList<TransferEventResponse>(valueList.size());\n    for (com.platon.tx.Contract.EventValuesWithLog eventValues : valueList) {\n      TransferEventResponse typedResponse = new TransferEventResponse();\n      typedResponse.log = eventValues.getLog();\n      typedResponse.id = (byte[]) eventValues.getIndexedValues().get(0).getValue();\n      typedResponse.from = (java.lang.String) eventValues.getIndexedValues().get(1).getValue();\n      typedResponse.to = (java.lang.String) eventValues.getIndexedValues().get(2).getValue();\n      typedResponse.value = (java.math.BigInteger) eventValues.getNonIndexedValues().get(0).getValue();\n      typedResponse.message = (java.lang.String) eventValues.getNonIndexedValues().get(1).getValue();\n      responses.add(typedResponse);\n    }\n    return responses;\n  }\n\n  public rx.Observable<TransferEventResponse> transferEventObservable(com.platon.protocol.core.methods.request.PlatonFilter filter) {\n    return web3j.platonLogObservable(filter).map(new rx.functions.Func1<com.platon.protocol.core.methods.response.Log, TransferEventResponse>() {\n      @java.lang.Override\n      public TransferEventResponse call(com.platon.protocol.core.methods.response.Log log) {\n        com.platon.tx.Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFER_EVENT, log);\n        TransferEventResponse typedResponse = new TransferEventResponse();\n        typedResponse.log = log;\n        typedResponse.id = (byte[]) eventValues.getIndexedValues().get(0).getValue();\n        typedResponse.from = (java.lang.String) eventValues.getIndexedValues().get(1).getValue();\n        typedResponse.to = (java.lang.String) eventValues.getIndexedValues().get(2).getValue();\n        typedResponse.value = (java.math.BigInteger) eventValues.getNonIndexedValues().get(0).getValue();\n        typedResponse.message = (java.lang.String) eventValues.getNonIndexedValues().get(1).getValue();\n        return typedResponse;\n      }\n    });\n  }\n\n  public rx.Observable<TransferEventResponse> transferEventObservable(com.platon.protocol.core.DefaultBlockParameter startBlock, com.platon.protocol.core.DefaultBlockParameter endBlock) {\n    com.platon.protocol.core.methods.request.PlatonFilter filter = new com.platon.protocol.core.methods.request.PlatonFilter(startBlock, endBlock, getContractAddress());\n    filter.addSingleTopic(com.platon.abi.solidity.EventEncoder.encode(TRANSFER_EVENT));\n    return transferEventObservable(filter);\n  }\n\n  public static class TransferEventResponse {\n    public com.platon.protocol.core.methods.response.Log log;\n\n    public byte[] id;\n\n    public java.lang.String from;\n\n    public java.lang.String to;\n\n    public java.math.BigInteger value;\n\n    public java.lang.String message;\n  }\n}\n";
        Assert.assertThat((Object)builder.build().toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testBuildFuncNameConstants() throws Exception {
        AbiDefinition functionDefinition = new AbiDefinition(false, Arrays.asList(new AbiDefinition.NamedType("param", "uint8")), "functionName", Collections.emptyList(), "function", true);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"testClass");
        builder.addFields(this.solidityFunctionWrapper.buildFuncNameConstants(Collections.singletonList(functionDefinition)));
        String expected = "class testClass {\n  public static final java.lang.String FUNC_FUNCTIONNAME = \"functionName\";\n}\n";
        Assert.assertThat((Object)builder.build().toString(), (Matcher)Is.is((Object)expected));
    }
}

