/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.platon.TempFileProvider;
import com.platon.codegen.TupleGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Test;

public class TupleGeneratorTest
extends TempFileProvider {
    @Test
    public void testTuplesGeneration() throws IOException {
        TupleGenerator.main((String[])new String[]{this.tempDirPath});
        String baseDir = this.tempDirPath + File.separatorChar + "org.web3j.tuples.generated".replace('.', File.separatorChar);
        String fileNameBase = baseDir + File.separator + "Tuple";
        ArrayList<String> fileNames = new ArrayList<String>(20);
        for (int i = 1; i <= 20; ++i) {
            fileNames.add(fileNameBase + i + ".java");
        }
        this.verifyGeneratedCode(fileNames);
    }

    private void verifyGeneratedCode(List<String> sourceFiles) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(sourceFiles);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            Assert.assertTrue((String)"Generated code contains compile time error", (boolean)task.call());
        }
    }
}

