/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.platon.codegen.Console;
import com.platon.codegen.FunctionWrapperGenerator;
import com.platon.codegen.WasmFunctionWrapper;
import com.platon.protocol.ObjectMapperFactory;
import com.platon.protocol.core.methods.response.WasmAbiDefinition;
import com.platon.utils.Collection;
import com.platon.utils.Files;
import com.platon.utils.Numeric;
import com.platon.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class WasmFunctionWrapperGenerator
extends FunctionWrapperGenerator {
    private static final String USAGE = "wasm generate <input binary file>.bin <input abi file>.abi.json -p|--package <base package name> -o|--output <destination base directory>";
    private final String binaryFileLocation;
    private final String absFileLocation;

    private WasmFunctionWrapperGenerator(String binaryFileLocation, String absFileLocation, String destinationDirLocation, String basePackageName, boolean useJavaNativeTypes) {
        super(destinationDirLocation, basePackageName, useJavaNativeTypes);
        this.binaryFileLocation = binaryFileLocation;
        this.absFileLocation = absFileLocation;
    }

    public static void run(String[] args) throws Exception {
        if (args.length < 1 || !args[0].equals("generate")) {
            Console.exitError(USAGE);
        } else {
            WasmFunctionWrapperGenerator.main(Collection.tail((String[])args));
        }
    }

    public static void main(String[] args) throws Exception {
        String[] fullArgs;
        if (args.length == 6) {
            fullArgs = new String[args.length + 1];
            fullArgs[0] = "--javaTypes";
            System.arraycopy(args, 0, fullArgs, 1, args.length);
        } else {
            fullArgs = args;
        }
        if (fullArgs.length != 7) {
            Console.exitError(USAGE);
        }
        boolean useJavaNativeTypes = WasmFunctionWrapperGenerator.useJavaNativeTypes(fullArgs[0], USAGE);
        String binaryFileLocation = WasmFunctionWrapperGenerator.parsePositionalArg(fullArgs, 1);
        String absFileLocation = WasmFunctionWrapperGenerator.parsePositionalArg(fullArgs, 2);
        String destinationDirLocation = WasmFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-o", "--outputDir");
        String basePackageName = WasmFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-p", "--package");
        if (binaryFileLocation.equals("") || absFileLocation.equals("") || destinationDirLocation.equals("") || basePackageName.equals("")) {
            Console.exitError(USAGE);
        }
        new WasmFunctionWrapperGenerator(binaryFileLocation, absFileLocation, destinationDirLocation, basePackageName, useJavaNativeTypes).generate();
    }

    static List<WasmAbiDefinition> loadContractDefinition(File absFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        WasmAbiDefinition[] abiDefinition = (WasmAbiDefinition[])objectMapper.readValue(absFile, WasmAbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private void generate() throws IOException, ClassNotFoundException {
        File binaryFile = new File(this.binaryFileLocation);
        if (!binaryFile.exists()) {
            Console.exitError("Invalid input binary file specified: " + this.binaryFileLocation);
        }
        byte[] bytes = Files.readBytes((File)new File(binaryFile.toURI()));
        String binary = Numeric.toHexString((byte[])bytes);
        File absFile = new File(this.absFileLocation);
        if (!absFile.exists() || !absFile.canRead()) {
            Console.exitError("Invalid input ABI file specified: " + this.absFileLocation);
        }
        String fileName = absFile.getName();
        String contractName = WasmFunctionWrapperGenerator.getFileNameNoExtension(WasmFunctionWrapperGenerator.getFileNameNoExtension(fileName));
        bytes = Files.readBytes((File)new File(absFile.toURI()));
        String abi = new String(bytes);
        List<WasmAbiDefinition> functionDefinitions = WasmFunctionWrapperGenerator.loadContractDefinition(absFile);
        if (functionDefinitions.isEmpty()) {
            Console.exitError("Unable to parse input ABI file");
        } else {
            String className = Strings.capitaliseFirstLetter((String)contractName);
            System.out.println("Generating " + this.basePackageName + "." + className + " ... ");
            new WasmFunctionWrapper().generateJavaFiles(contractName, binary, abi, this.destinationDirLocation.toString(), this.basePackageName);
            System.out.println("File written to " + this.destinationDirLocation.toString() + "\n");
        }
    }
}

